/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.client;

import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CollectExternalRestClient
extends BasePaginatingAndSortingRestClient<CollectProjectDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CollectExternalRestClient.class);

    public CollectExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected Class<CollectProjectDto> getDtoClass() {
        return CollectProjectDto.class;
    }

    protected ParameterizedTypeReference<List<CollectProjectDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<CollectProjectDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CollectProjectDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CollectProjectDto>>(){};
    }

    public String getPathUrl() {
        return "/collect-api/v1/projects";
    }

    private String getTransactionUrl() {
        if (this.baseUrl != null) {
            return this.baseUrl + "/collect-api/v1/transactions";
        }
        return "/collect-api/v1/transactions";
    }

    public ArchiveUnitsDto searchArchiveUnitsByProjectAndSearchQuery(ExternalHttpContext context, String projectId, SearchCriteriaDto searchQuery) {
        HttpEntity request = new HttpEntity((Object)searchQuery);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + projectId + "/archive-units", HttpMethod.POST, request, ArchiveUnitsDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (ArchiveUnitsDto)response.getBody();
    }

    public ResponseEntity<ResultsDto> findObjectById(String id, ExternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/object-groups/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public void deleteProject(String id, ExternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.DELETE, request, Void.class);
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>> getTransactionDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>>(){};
    }

    public PaginatedValuesDto<CollectTransactionDto> getTransactionsByProjectPaginated(ExternalHttpContext context, Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, String projectId) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("search page={}, size={}, criteria={}, orderBy={}, direction={}", new Object[]{page, size, criteria, orderBy, direction});
        URIBuilder builder = this.getUriBuilder(this.getUrl() + "/" + projectId + "//transactions");
        builder.addParameter("page", page.toString());
        builder.addParameter("size", size.toString());
        criteria.ifPresent(o -> builder.addParameter("criteria", o));
        orderBy.ifPresent(o -> builder.addParameter("orderBy", o));
        direction.ifPresent(o -> builder.addParameter("direction", o.toString()));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, this.getTransactionDtoPaginatedClass());
        this.checkResponse(response, new Integer[0]);
        return (PaginatedValuesDto)response.getBody();
    }

    public CollectTransactionDto createTransactionForProject(ExternalHttpContext context, CollectTransactionDto collectTransactionDto, String projectId) {
        HttpEntity request = new HttpEntity((Object)collectTransactionDto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/" + projectId + "/transactions", HttpMethod.POST, request, CollectTransactionDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (CollectTransactionDto)response.getBody();
    }

    public CollectTransactionDto getLastTransactionForProjectId(String id, ExternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{id}/last-transaction"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, CollectTransactionDto.class);
        this.checkResponse(response, new Integer[0]);
        return (CollectTransactionDto)response.getBody();
    }
}

