/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.security.client;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseCrudRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.security.common.dto.ContextDto;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ContextRestClient
extends BaseCrudRestClient<ContextDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ContextRestClient.class);

    public ContextRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public ContextDto findByCertificate(InternalHttpContext context, String certificate) {
        LOGGER.debug("certificate(truncated): {}****", (Object)StringUtils.substring((String)certificate, (int)0, (int)100));
        HttpEntity request = new HttpEntity((Object)certificate, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/certificate", HttpMethod.POST, request, this.getDtoClass(), new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (ContextDto)response.getBody();
    }

    public ContextDto addTenant(InternalHttpContext context, String id, String tenantIdentifier) {
        LOGGER.debug("Add Tenant {}, to {}", (Object)tenantIdentifier, (Object)id);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        uriBuilder.path("/{id}/tenant/{tenantIdentifier}");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id, tenantIdentifier}), HttpMethod.PATCH, request, this.getDtoClass());
        this.checkResponse(response, new Integer[0]);
        return (ContextDto)response.getBody();
    }

    public String getPathUrl() {
        return "/security/v1/contexts";
    }

    protected Class<ContextDto> getDtoClass() {
        return ContextDto.class;
    }

    protected ParameterizedTypeReference<List<ContextDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ContextDto>>(){};
    }
}

