/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class UserInternalRestClient
extends BasePaginatingAndSortingRestClient<UserDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserInternalRestClient.class);

    public UserInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public Resource exportUsers(InternalHttpContext context, Optional<String> criteria) {
        LOGGER.debug("Export users");
        URIBuilder uriBuilder = this.getUriBuilderFromPath("/export");
        criteria.ifPresent(o -> uriBuilder.addParameter("criteria", o));
        URI uri = this.buildUriBuilder(uriBuilder);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, request, Resource.class);
        this.checkResponse(response, new Integer[0]);
        return (Resource)response.getBody();
    }

    public Resource exportUserConnectionHistory(InternalHttpContext context, Optional<String> criteria) {
        LOGGER.debug("Export user connection history with criteria: {}", criteria);
        URIBuilder uriBuilder = this.getUriBuilderFromPath("/connection-history/export");
        criteria.ifPresent(o -> uriBuilder.addParameter("criteria", o));
        URI uri = this.buildUriBuilder(uriBuilder);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, request, Resource.class);
        this.checkResponse(response, new Integer[0]);
        return (Resource)response.getBody();
    }

    public AuthUserDto getMe(InternalHttpContext context) {
        LOGGER.debug("GetMe");
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/me"));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, AuthUserDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (AuthUserDto)response.getBody();
    }

    public UserDto patch(InternalHttpContext context, Map<String, Object> partialDto) {
        LOGGER.debug("Patch partialDto={}");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        uriBuilder.path("/{id}");
        String id = (String)partialDto.get("id");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity(partialDto, headers);
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PATCH, request, this.getDtoClass());
        this.checkResponse(response, new Integer[0]);
        return (UserDto)response.getBody();
    }

    public List<String> getLevels(InternalHttpContext context, Optional<String> criteria) {
        LOGGER.debug("GetLevels criteria={}", criteria);
        URIBuilder builder = this.getUriBuilderFromPath("/levels");
        criteria.ifPresent(o -> builder.addParameter("criteria", o));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, this.getStringListClass());
        this.checkResponse(response, new Integer[0]);
        return (List)response.getBody();
    }

    public UserDto patchAnalytics(InternalHttpContext context, Map<String, Object> partialDto) {
        LOGGER.debug("Patch analytics partialDto={}");
        URIBuilder uriBuilder = this.getUriBuilderFromPath("/analytics");
        URI uri = this.buildUriBuilder(uriBuilder);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity(partialDto, headers);
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.POST, request, this.getDtoClass());
        this.checkResponse(response, new Integer[0]);
        return (UserDto)response.getBody();
    }

    public String getPathUrl() {
        return "/iam/v1/users";
    }

    protected Class<UserDto> getDtoClass() {
        return UserDto.class;
    }

    protected ParameterizedTypeReference<List<UserDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<UserDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<UserDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<UserDto>>(){};
    }

    private ParameterizedTypeReference<List<String>> getStringListClass() {
        return new ParameterizedTypeReference<List<String>>(){};
    }
}

