/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.external.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class IngestExternalRestClient
extends BasePaginatingAndSortingRestClient<LogbookOperationDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestExternalRestClient.class);

    public IngestExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/v1/ingest";
    }

    protected Class<LogbookOperationDto> getDtoClass() {
        return LogbookOperationDto.class;
    }

    protected ParameterizedTypeReference<List<LogbookOperationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<LogbookOperationDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<LogbookOperationDto>>(){};
    }

    public ResponseEntity<byte[]> generateODTReport(ExternalHttpContext context, String id) {
        LOGGER.debug("Generate odt file for ingest with id : {}", (Object)id);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/odtreport/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, byte[].class);
    }
}

