/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.external.server.service;

import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.ingest.internal.client.IngestInternalRestClient;
import fr.gouv.vitamui.ingest.internal.client.IngestInternalWebClient;
import fr.gouv.vitamui.ingest.internal.client.IngestStreamingInternalRestClient;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class IngestExternalService
extends AbstractResourceClientService<LogbookOperationDto, LogbookOperationDto> {
    @Autowired
    private final IngestInternalRestClient ingestInternalRestClient;
    @Autowired
    private final IngestInternalWebClient ingestInternalWebClient;
    @Autowired
    private final IngestStreamingInternalRestClient ingestStreamingInternalRestClient;

    public IngestExternalService(@Autowired IngestInternalRestClient ingestInternalRestClient, IngestInternalWebClient ingestInternalWebClient, ExternalSecurityService externalSecurityService, IngestStreamingInternalRestClient ingestStreamingInternalRestClient) {
        super(externalSecurityService);
        this.ingestInternalRestClient = ingestInternalRestClient;
        this.ingestInternalWebClient = ingestInternalWebClient;
        this.ingestStreamingInternalRestClient = ingestStreamingInternalRestClient;
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(arg_0 -> ((IngestExternalService)this).converterToExternalDto(arg_0)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public LogbookOperationDto getOne(String id) {
        return (LogbookOperationDto)this.ingestInternalRestClient.getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ResponseEntity<byte[]> generateODTReport(String id) {
        return this.ingestInternalRestClient.generateODTReport(this.getInternalHttpContext(), id);
    }

    protected IngestInternalRestClient getClient() {
        return this.ingestInternalRestClient;
    }

    public ResponseEntity<Void> streamingUpload(InputStream inputStream, String contextId, String action) {
        return this.ingestStreamingInternalRestClient.streamingUpload(this.getInternalHttpContext(), inputStream, contextId, action);
    }

    @Generated
    public IngestInternalRestClient getIngestInternalRestClient() {
        return this.ingestInternalRestClient;
    }

    @Generated
    public IngestInternalWebClient getIngestInternalWebClient() {
        return this.ingestInternalWebClient;
    }

    @Generated
    public IngestStreamingInternalRestClient getIngestStreamingInternalRestClient() {
        return this.ingestStreamingInternalRestClient;
    }
}

