/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.standalone.controller;

import fr.gouv.vitamui.commons.utils.VitamUIStringUtils;
import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.profiles.Notice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileNotice;
import fr.gouv.vitamui.pastis.common.dto.profiles.ProfileResponse;
import fr.gouv.vitamui.pastis.common.exception.TechnicalException;
import fr.gouv.vitamui.pastis.server.service.PastisService;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@OpenAPIDefinition(tags={@Tag(name="pastis")}, info=@Info(title="Pastis Rest Api"), servers={@Server(url="localhost", variables={@ServerVariable(name="scheme", allowableValues={"https", "http"}, defaultValue="http"), @ServerVariable(name="port", description="Api port", defaultValue="8096")})})
@RestController
class PastisController {
    private static final boolean IS_STANDALONE = true;
    private static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private final PastisService profileService;

    @Autowired
    public PastisController(PastisService profileService) {
        this.profileService = profileService;
    }

    private static boolean isInvalidFilename(String fileName) {
        return VitamUIStringUtils.HTML_PATTERN.matcher(fileName).find();
    }

    @Operation(summary="Retrieve RNG representation of the JSON structure", description="Retrieve RNG representation of the JSON structure of archive profile", tags={"pastis"})
    @PostMapping(value={"/archiveprofile"}, consumes={"application/json; charset=utf-8"}, produces={"application/xml"})
    ResponseEntity<String> getArchiveProfile(@RequestBody ElementProperties json) throws TechnicalException {
        String pa = this.profileService.getArchiveProfile(json);
        if (pa == null) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.NO_ARCHIVE_PROFILE.toString());
        }
        return ResponseEntity.ok((Object)pa);
    }

    @Operation(summary="Retrieve JSON representation of archive unit profile", description="Retrieve JSON representation of archive unit profile", tags={"pastis"})
    @PostMapping(value={"/getarchiveunitprofile"}, consumes={"application/json; charset=utf-8"}, produces={"application/json"})
    ResponseEntity<String> getArchiveUnitProfile(@RequestBody ProfileNotice json) throws TechnicalException {
        String pua = this.profileService.getArchiveUnitProfile(json, true);
        if (pua == null) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.NO_ARCHIVE_UNIT_PROFILE.toString());
        }
        return ResponseEntity.ok((Object)pua);
    }

    @Operation(summary="Retrieve JSON representation of the RNG structure", description="Retrieve JSON representation of the RNG structure", tags={"pastis"})
    @GetMapping(value={"/profile"})
    ResponseEntity<ProfileResponse> createProfile(@RequestParam(name="type") String profileType) throws NoSuchAlgorithmException, TechnicalException {
        ProfileResponse profileResponse = this.profileService.createProfile(profileType, true);
        if (profileResponse == null) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.NO_PROFILE_RESPONSE.toString());
        }
        return ResponseEntity.ok((Object)profileResponse);
    }

    @GetMapping(value={"/getfile"})
    ResponseEntity<Resource> getFile(@RequestParam(name="name") String filename) {
        Resource resource = this.profileService.getFile(filename);
        if (PastisController.isInvalidFilename(filename)) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.INVALID_FILE_NAME.toString());
        }
        if (resource == null) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.RESOURCE_NOT_FOUND.toString());
        }
        return ResponseEntity.ok((Object)resource);
    }

    @Operation(summary="Transform profile JSON representation from Notice", description="Transform profile JSON representation from Notice", tags={"pastis"})
    @PostMapping(value={"/edit"})
    ResponseEntity<ProfileResponse> loadProfile(@RequestBody Notice notice) throws TechnicalException {
        ProfileResponse profileResponse = this.profileService.loadProfile(notice);
        if (profileResponse == null) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.NO_PROFILE_RESPONSE.toString());
        }
        return ResponseEntity.ok((Object)profileResponse);
    }

    @Operation(summary="Upload profile PA or PUA", description="Upload profile PA or PUA", tags={"pastis"})
    @PostMapping(value={"/profile"}, consumes={"multipart/form-data"}, produces={"application/json"})
    ResponseEntity<ProfileResponse> loadProfileFromFile(@RequestParam MultipartFile file) throws NoSuchAlgorithmException, TechnicalException {
        String originalFileName = file.getOriginalFilename();
        if (PastisController.isInvalidFilename(originalFileName)) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.INVALID_FILE_NAME.toString());
        }
        ProfileResponse profileResponse = this.profileService.loadProfileFromFile(file, originalFileName, true);
        if (profileResponse == null) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, ErrorMessage.NO_PROFILE_RESPONSE.toString());
        }
        return ResponseEntity.ok((Object)profileResponse);
    }

    @Operation(summary="Retrieve all profiles PA and PUA", description="Retrieve all profiles PA and PUA", tags={"pastis"})
    @GetMapping(value={"/getprofiles"})
    ResponseEntity<List<Notice>> getFiles() throws TechnicalException {
        List notices = this.profileService.getFiles();
        if (!notices.isEmpty()) {
            return ResponseEntity.ok((Object)notices);
        }
        return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    static enum ErrorMessage {
        INVALID_FILE_NAME("Invalid file name"),
        NO_PROFILE_RESPONSE("No profile response"),
        RESOURCE_NOT_FOUND("Resource not found"),
        NO_ARCHIVE_PROFILE("No archive profile"),
        NO_ARCHIVE_UNIT_PROFILE("No archive unit profile");

        private final String name;

        private ErrorMessage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

