/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.client;

import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.referential.common.dto.SchemaDto;
import fr.gouv.vitamui.referential.common.model.Collection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class SchemaClient
extends BaseRestClient<ExternalHttpContext> {
    public SchemaClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/schemas";
    }

    public List<SchemaDto> getSchemas(ExternalHttpContext externalHttpContext, Set<Collection> collections) throws URISyntaxException {
        URI uri = new URIBuilder(this.getUrl()).addParameter("collections", collections.stream().map(Enum::name).collect(Collectors.joining(","))).build();
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, this.generateHeaders((AbstractHttpContext)externalHttpContext), SchemaDto[].class);
        return Arrays.asList(Objects.requireNonNull((SchemaDto[])responseEntity.getBody()));
    }

    private HttpEntity<?> generateHeaders(AbstractHttpContext abstractHttpContext) {
        return new HttpEntity(this.buildHeaders(abstractHttpContext));
    }
}

