/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.rest.dto.RuleDto;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RuleExternalRestClient
extends BasePaginatingAndSortingRestClient<RuleDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(RuleExternalRestClient.class);

    public RuleExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<RuleDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<RuleDto>>(){};
    }

    public String getPathUrl() {
        return "/referential/v1/rules";
    }

    protected Class<RuleDto> getDtoClass() {
        return RuleDto.class;
    }

    protected ParameterizedTypeReference<List<RuleDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<RuleDto>>(){};
    }

    public boolean check(ExternalHttpContext context, RuleDto ruleDto) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/check"));
        HttpEntity request = new HttpEntity((Object)ruleDto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Boolean.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK;
    }

    public boolean createRule(ExternalHttpContext context, RuleDto dto) {
        LOGGER.debug("Create {}", (Object)dto);
        HttpEntity request = new HttpEntity((Object)dto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl(), HttpMethod.POST, request, Boolean.class, new Object[0]);
        this.checkResponse(response, new Integer[]{200, 201, 202, 204});
        return response.getStatusCode() == HttpStatus.OK | response.getStatusCode() == HttpStatus.CREATED;
    }

    public boolean patchRule(ExternalHttpContext context, Map<String, Object> partialDto, String id) {
        LOGGER.debug("Patch {}", partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for patch.");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        uriBuilder.path("/{id}");
        HttpEntity request = new HttpEntity(partialDto, this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.PATCH, request, Boolean.class);
        this.checkResponse(response, new Integer[]{200, 201, 202, 204});
        return response.getStatusCode() == HttpStatus.OK;
    }

    public boolean deleteRule(ExternalHttpContext context, String id) {
        LOGGER.debug("Delete {}", (Object)id);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/{id}", HttpMethod.DELETE, request, Boolean.class, new Object[]{id});
        this.checkResponse(response, new Integer[]{200, 201, 202, 204});
        return response.getStatusCode() == HttpStatus.OK;
    }

    public ResponseEntity<Resource> export(ExternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/export"));
        HttpEntity request = new HttpEntity(null, this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, Resource.class, new Object[0]);
    }
}

