/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Optional;
import org.springframework.http.HttpMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

public class OntologyExternalWebClient
extends BaseWebClient<ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyExternalWebClient.class);

    public OntologyExternalWebClient(WebClient webClient, String baseUrl) {
        super(webClient, baseUrl);
    }

    public JsonNode importOntologies(ExternalHttpContext context, MultipartFile file) {
        LOGGER.debug("Import file {}", (Object)(file != null ? file.getOriginalFilename() : null));
        if (file == null) {
            throw new BadRequestException("No file to check .");
        }
        return (JsonNode)this.multipartData(this.getUrl() + "/import", HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("fileName", file.getOriginalFilename()), Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("file", file)), JsonNode.class);
    }

    public String getPathUrl() {
        return "/referential/v1/ontology";
    }
}

