/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.external.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.archive.internal.client.ArchiveInternalRestClient;
import fr.gouv.archive.internal.client.ArchiveSearchInternalWebClient;
import fr.gouv.archive.internal.client.ArchiveSearchStreamingInternalRestClient;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.archives.search.external.server.service.ArchiveSearchThresholdService;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.PersistentIdentifierResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.QualifiersDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VersionsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.commons.vitam.api.model.ObjectQualifierType;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
public class ArchivesSearchExternalService
extends AbstractResourceClientService<ArchiveUnitsDto, ArchiveUnitsDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchivesSearchExternalService.class);
    @Autowired
    private final ArchiveInternalRestClient archiveInternalRestClient;
    @Autowired
    private final ArchiveSearchThresholdService archiveSearchThresholdService;
    @Autowired
    private final ArchiveSearchInternalWebClient archiveSearchInternalWebClient;
    @Autowired
    private final ArchiveSearchStreamingInternalRestClient archiveSearchStreamingInternalRestClient;

    public ArchivesSearchExternalService(@Autowired ArchiveInternalRestClient archiveInternalRestClient, ArchiveSearchInternalWebClient archiveSearchInternalWebClient, ExternalSecurityService externalSecurityService, ArchiveSearchStreamingInternalRestClient archiveSearchStreamingInternalRestClient, ArchiveSearchThresholdService archiveSearchThresholdService) {
        super(externalSecurityService);
        this.archiveInternalRestClient = archiveInternalRestClient;
        this.archiveSearchInternalWebClient = archiveSearchInternalWebClient;
        this.archiveSearchStreamingInternalRestClient = archiveSearchStreamingInternalRestClient;
        this.archiveSearchThresholdService = archiveSearchThresholdService;
    }

    protected ArchiveInternalRestClient getClient() {
        return this.archiveInternalRestClient;
    }

    public VitamUIArchiveUnitResponseDto searchArchiveUnitsByCriteria(SearchCriteriaDto query) {
        ArchiveUnitsDto archiveUnitsDto;
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            query.setThreshold(thresholdOpt.get());
        }
        return (archiveUnitsDto = this.getClient().searchArchiveUnitsByCriteria(this.getInternalHttpContext(), query)) == null ? null : archiveUnitsDto.getArchives();
    }

    public ResponseEntity<ResultsDto> findUnitById(String id) {
        return this.archiveInternalRestClient.findUnitById(id, this.getInternalHttpContext());
    }

    public ResponseEntity<ResultsDto> findObjectById(String id) {
        return this.archiveInternalRestClient.findObjectById(id, this.getInternalHttpContext());
    }

    public VitamUISearchResponseDto getFilingHoldingScheme() {
        return this.archiveInternalRestClient.getFilingHoldingScheme(this.getInternalHttpContext());
    }

    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(String id, String usage, Integer version) {
        String fileName = null;
        ResultsDto got = (ResultsDto)this.findObjectById(id).getBody();
        if (Objects.nonNull(got)) {
            QualifiersDto qualifier;
            if (ObjectUtils.isEmpty((Object)usage)) {
                qualifier = this.getLastObjectQualifier(got);
            } else {
                String finalUsage = usage;
                qualifier = got.getQualifiers().stream().filter(q -> finalUsage.equals(q.getQualifier())).findFirst().orElse(null);
            }
            if (Objects.nonNull(qualifier)) {
                VersionsDto versionsDto;
                usage = qualifier.getQualifier();
                if (Objects.isNull(version)) {
                    versionsDto = this.getLastVersion(qualifier);
                } else {
                    Integer finalVersion = version;
                    versionsDto = qualifier.getVersions().stream().filter(v -> finalVersion.equals(ArchivesSearchExternalService.extractVersion(v))).findFirst().orElse(null);
                }
                if (Objects.nonNull(versionsDto)) {
                    version = ArchivesSearchExternalService.extractVersion(versionsDto);
                    fileName = this.getFilename(versionsDto);
                }
            }
        }
        return this.archiveSearchInternalWebClient.downloadObjectFromUnit(id, usage, version, this.getInternalHttpContext(), fileName);
    }

    private QualifiersDto getLastObjectQualifier(ResultsDto got) {
        for (String qualifierName : ObjectQualifierType.allValuesOrdered) {
            QualifiersDto qualifierFound = got.getQualifiers().stream().filter(qualifier -> qualifierName.equals(qualifier.getQualifier())).reduce((first, second) -> second).orElse(null);
            if (!Objects.nonNull(qualifierFound)) continue;
            return qualifierFound;
        }
        return null;
    }

    private VersionsDto getLastVersion(QualifiersDto qualifier) {
        return qualifier.getVersions().stream().max(Comparator.comparing(ArchivesSearchExternalService::extractVersion)).orElse(null);
    }

    @NotNull
    private static Integer extractVersion(VersionsDto versionsDto) {
        return Integer.parseInt(versionsDto.getDataObjectVersion().split("_")[1]);
    }

    private String getFilename(VersionsDto version) {
        if (Objects.isNull(version) || StringUtils.isEmpty((CharSequence)version.getId())) {
            return null;
        }
        return version.getId() + this.getExtension(version);
    }

    private String getExtension(VersionsDto version) {
        String uriExtension = "";
        if (StringUtils.isNotBlank((CharSequence)version.getUri()) && version.getUri().contains(".")) {
            uriExtension = version.getUri().substring(version.getUri().lastIndexOf(46) + 1);
        }
        String filenameExtension = "";
        if (Objects.nonNull(version.getFileInfoModel()) && StringUtils.isNotBlank((CharSequence)version.getFileInfoModel().getFilename()) && version.getFileInfoModel().getFilename().contains(".")) {
            filenameExtension = version.getFileInfoModel().getFilename().substring(version.getFileInfoModel().getFilename().lastIndexOf(46) + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)filenameExtension)) {
            return "." + filenameExtension;
        }
        if (StringUtils.isNotBlank((CharSequence)uriExtension)) {
            return "." + uriExtension;
        }
        return "";
    }

    public Resource exportCsvArchiveUnitsByCriteria(SearchCriteriaDto query) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            query.setThreshold(thresholdOpt.get());
        }
        return this.archiveInternalRestClient.exportCsvArchiveUnitsByCriteria(query, this.getInternalHttpContext());
    }

    public String exportDIPByCriteria(ExportDipCriteriaDto exportDipCriteriaDto) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            exportDipCriteriaDto.getExportDIPSearchCriteria().setThreshold(thresholdOpt.get());
        }
        return this.archiveInternalRestClient.exportDIPByCriteria(exportDipCriteriaDto, this.getInternalHttpContext());
    }

    public String transferRequest(TransferRequestDto transferRequestDto) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            transferRequestDto.getSearchCriteria().setThreshold(thresholdOpt.get());
        }
        return this.archiveInternalRestClient.transferRequest(transferRequestDto, this.getInternalHttpContext());
    }

    public ResponseEntity<JsonNode> startEliminationAnalysis(SearchCriteriaDto query) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            query.setThreshold(thresholdOpt.get());
        }
        return this.archiveInternalRestClient.startEliminationAnalysis(this.getInternalHttpContext(), query);
    }

    public ResponseEntity<JsonNode> startEliminationAction(SearchCriteriaDto query) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            query.setThreshold(thresholdOpt.get());
        }
        return this.archiveInternalRestClient.startEliminationAction(this.getInternalHttpContext(), query);
    }

    public String updateArchiveUnitsRules(RuleSearchCriteriaDto ruleSearchCriteriaDto) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            ruleSearchCriteriaDto.getSearchCriteriaDto().setThreshold(thresholdOpt.get());
        }
        return this.archiveInternalRestClient.updateArchiveUnitsRules(ruleSearchCriteriaDto, this.getInternalHttpContext());
    }

    public String computedInheritedRules(SearchCriteriaDto searchCriteriaDto) {
        return this.archiveInternalRestClient.computedInheritedRules(searchCriteriaDto, this.getInternalHttpContext());
    }

    public ResultsDto selectUnitWithInheritedRules(SearchCriteriaDto query) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            query.setThreshold(thresholdOpt.get());
        }
        return this.getClient().selectUnitWithInheritedRules(this.getInternalHttpContext(), query);
    }

    public String reclassification(ReclassificationCriteriaDto reclassificationCriteriaDto) {
        Optional<Long> thresholdOpt = this.archiveSearchThresholdService.retrieveProfilThresholds();
        if (thresholdOpt.isPresent()) {
            reclassificationCriteriaDto.getSearchCriteriaDto().setThreshold(thresholdOpt.get());
        }
        return this.archiveInternalRestClient.reclassification(reclassificationCriteriaDto, this.getInternalHttpContext());
    }

    public String transferAcknowledgment(InputStream atrInputStream, String originalFileName) {
        return this.archiveSearchStreamingInternalRestClient.transferAcknowledgment(this.getInternalHttpContext(), originalFileName, atrInputStream);
    }

    public List<VitamUiOntologyDto> getExternalOntologiesList() {
        return this.archiveInternalRestClient.getExternalOntologiesList(this.getInternalHttpContext());
    }

    public PersistentIdentifierResponseDto findUnitsByPersistentIdentifier(String arkId) {
        return this.archiveInternalRestClient.findUnitsByPersistentIdentifier(arkId, this.getInternalHttpContext());
    }

    public PersistentIdentifierResponseDto findObjectsByPersistentIdentifier(String arkId) {
        return this.archiveInternalRestClient.findObjectsByPersistentIdentifier(arkId, this.getInternalHttpContext());
    }

    @Generated
    public ArchiveInternalRestClient getArchiveInternalRestClient() {
        return this.archiveInternalRestClient;
    }

    @Generated
    public ArchiveSearchThresholdService getArchiveSearchThresholdService() {
        return this.archiveSearchThresholdService;
    }

    @Generated
    public ArchiveSearchInternalWebClient getArchiveSearchInternalWebClient() {
        return this.archiveSearchInternalWebClient;
    }

    @Generated
    public ArchiveSearchStreamingInternalRestClient getArchiveSearchStreamingInternalRestClient() {
        return this.archiveSearchStreamingInternalRestClient;
    }
}

