/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.archives.search.external.server.service.SearchCriteriaHistoryExternalService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaHistoryDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/searchcriteriahistory"})
@Api(tags={"searchCriteriaHistory"}, value="Search Criteria History")
public class SearchCriteriaHistoryExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SearchCriteriaHistoryExternalController.class);
    private SearchCriteriaHistoryExternalService searchCriteriaHistoryExternalService;

    @Autowired
    public SearchCriteriaHistoryExternalController(SearchCriteriaHistoryExternalService searchCriteriaHistoryExternalService) {
        this.searchCriteriaHistoryExternalService = searchCriteriaHistoryExternalService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_ALL_ARCHIVE_SEARCH"})
    public List<SearchCriteriaHistoryDto> getSearchCriteriaHistory() {
        LOGGER.debug("getSearchCriteriaHistory archive external");
        return this.searchCriteriaHistoryExternalService.getSearchCriteriaHistory();
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_ARCHIVE_SEARCH"})
    public SearchCriteriaHistoryDto create(@Valid @RequestBody SearchCriteriaHistoryDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create SearchCriteriaHistory {}", (Object)dto);
        return this.searchCriteriaHistoryExternalService.create(dto);
    }

    @DeleteMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public void delete(@PathVariable(value="id") String id) throws PreconditionFailedException, InvalidParseOperationException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete SearchCriteriaHistory with id :{}", (Object)id);
        this.searchCriteriaHistoryExternalService.delete(id);
    }

    @ApiOperation(value="Update Search criteria history")
    @PutMapping(value={"/{id}"})
    @Secured(value={"ROLE_CREATE_ARCHIVE_SEARCH"})
    public void update(@RequestBody SearchCriteriaHistoryDto entity) throws PreconditionFailedException, InvalidParseOperationException {
        SanityChecker.sanitizeCriteria((Object)entity);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{entity.getId()});
        LOGGER.debug("Update SearchCriteriaHistory with id :{}", (Object)entity.getId());
        this.searchCriteriaHistoryExternalService.update(entity);
    }

    @Generated
    public SearchCriteriaHistoryExternalService getSearchCriteriaHistoryExternalService() {
        return this.searchCriteriaHistoryExternalService;
    }

    @Generated
    public void setSearchCriteriaHistoryExternalService(SearchCriteriaHistoryExternalService searchCriteriaHistoryExternalService) {
        this.searchCriteriaHistoryExternalService = searchCriteriaHistoryExternalService;
    }
}

