/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.external.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.archives.search.common.dto.VitamUIArchiveUnitResponseDto;
import fr.gouv.vitamui.archives.search.external.server.service.ArchivesSearchExternalService;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.PersistentIdentifierResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@Api(tags={"Archives search"})
@RequestMapping(value={"/archives-search"})
@RestController
@ResponseBody
public class ArchivesSearchExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchivesSearchExternalController.class);
    private static final String MANDATORY_QUERY = "The query is a mandatory parameter: ";
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private final ArchivesSearchExternalService archivesSearchExternalService;

    @Autowired
    public ArchivesSearchExternalController(ArchivesSearchExternalService archivesSearchExternalService) {
        this.archivesSearchExternalService = archivesSearchExternalService;
    }

    @PostMapping(value={"/search"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public VitamUIArchiveUnitResponseDto searchArchiveUnitsByCriteria(@RequestBody SearchCriteriaDto query) {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling search archive Units By Criteria {} ", (Object)query);
        return this.archivesSearchExternalService.searchArchiveUnitsByCriteria(query);
    }

    @GetMapping(value={"/filling-holding-schema"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public VitamUISearchResponseDto getFillingHoldingScheme() {
        return this.archivesSearchExternalService.getFilingHoldingScheme();
    }

    @GetMapping(value={"/downloadobjectfromunit/{id}"}, produces={"application/octet-stream"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(@PathVariable(value="id") String id, @RequestParam(value="usage", required=false) String usage, @RequestParam(value="version", required=false) Integer version) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the Archive Unit Object with id {} ", (Object)id);
        return this.archivesSearchExternalService.downloadObjectFromUnit(id, usage, version);
    }

    @GetMapping(value={"/archiveunit/{id}"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public ResponseEntity<ResultsDto> findUnitById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("the UA by id {} ", (Object)id);
        return this.archivesSearchExternalService.findUnitById(id);
    }

    @GetMapping(value={"/object/{id}"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public ResponseEntity<ResultsDto> findObjectById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find a ObjectGroup by id {} ", (Object)id);
        return this.archivesSearchExternalService.findObjectById(id);
    }

    @PostMapping(value={"/export-csv-search"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public Resource exportCsvArchiveUnitsByCriteria(@RequestBody SearchCriteriaDto query) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling export to csv search archive Units By Criteria {} ", (Object)query);
        return this.archivesSearchExternalService.exportCsvArchiveUnitsByCriteria(query);
    }

    @PostMapping(value={"/export-dip"})
    @Secured(value={"ROLE_EXPORT_DIP"})
    public String exportDIPByCriteria(@RequestBody ExportDipCriteriaDto exportDipCriteriaDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{exportDipCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)exportDipCriteriaDto);
        LOGGER.debug("Calling export DIP By Criteria {} ", (Object)exportDipCriteriaDto);
        return this.archivesSearchExternalService.exportDIPByCriteria(exportDipCriteriaDto);
    }

    @PostMapping(value={"/transfer-request"})
    @Secured(value={"ROLE_TRANSFER_REQUEST"})
    public String transferRequest(@RequestBody TransferRequestDto transferRequestDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{transferRequestDto});
        SanityChecker.sanitizeCriteria((Object)transferRequestDto);
        LOGGER.debug("Calling transfer request {} ", (Object)transferRequestDto);
        return this.archivesSearchExternalService.transferRequest(transferRequestDto);
    }

    @PostMapping(value={"/elimination/analysis"})
    @Secured(value={"ROLE_ELIMINATION"})
    public ResponseEntity<JsonNode> startEliminationAnalysis(@RequestBody SearchCriteriaDto query) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling elimination analysis by criteria {} ", (Object)query);
        return this.archivesSearchExternalService.startEliminationAnalysis(query);
    }

    @PostMapping(value={"/elimination/action"})
    @Secured(value={"ROLE_ELIMINATION"})
    public ResponseEntity<JsonNode> startEliminationAction(@RequestBody SearchCriteriaDto query) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling elimination action by criteria {} ", (Object)query);
        return this.archivesSearchExternalService.startEliminationAction(query);
    }

    @PostMapping(value={"/units/rules"})
    @Secured(value={"ROLE_UPDATE_MANAGEMENT_RULES"})
    public String updateArchiveUnitsRules(@RequestBody RuleSearchCriteriaDto ruleSearchCriteriaDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{ruleSearchCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)ruleSearchCriteriaDto);
        LOGGER.debug("Calling Update Archive Units Rules By Criteria {} ", (Object)ruleSearchCriteriaDto);
        return this.archivesSearchExternalService.updateArchiveUnitsRules(ruleSearchCriteriaDto);
    }

    @PostMapping(value={"/computed-inherited-rules"})
    @Secured(value={"ROLE_COMPUTED_INHERITED_RULES"})
    public String computedInheritedRules(@RequestBody SearchCriteriaDto searchCriteriaDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{searchCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)searchCriteriaDto);
        LOGGER.debug("Calling computed inherited rules By Criteria {} ", (Object)searchCriteriaDto);
        return this.archivesSearchExternalService.computedInheritedRules(searchCriteriaDto);
    }

    @PostMapping(value={"/unit-with-inherited-rules"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public ResultsDto selectUnitWithInheritedRules(@RequestBody SearchCriteriaDto query) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{query});
        SanityChecker.sanitizeCriteria((Object)query);
        LOGGER.debug("Calling select Unit With Inherited Rules By Criteria {} ", (Object)query);
        return this.archivesSearchExternalService.selectUnitWithInheritedRules(query);
    }

    @PostMapping(value={"/reclassification"})
    @Secured(value={"ROLE_RECLASSIFICATION"})
    public String reclassification(@RequestBody ReclassificationCriteriaDto reclassificationCriteriaDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_QUERY, (Object[])new Object[]{reclassificationCriteriaDto});
        SanityChecker.sanitizeCriteria((Object)reclassificationCriteriaDto);
        LOGGER.debug("Reclassification query {}", (Object)reclassificationCriteriaDto);
        return this.archivesSearchExternalService.reclassification(reclassificationCriteriaDto);
    }

    @Secured(value={"ROLE_TRANSFER_ACKNOWLEDGMENT"})
    @ApiOperation(value="Upload an ATR file for the transfer acknowledgment", consumes="application/octet-stream")
    @PostMapping(value={"/transfer-acknowledgment"}, consumes={"application/octet-stream"})
    public String transferAcknowledgment(InputStream inputStream, @RequestHeader(value="X-Original-Filename") String originalFileName) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("[EXTERNAL] : Transfer Acknowledgment Operation");
        ParameterChecker.checkParameter((String)"The  fileName is mandatory parameter : ", (String[])new String[]{originalFileName});
        SanityChecker.checkSecureParameter((String[])new String[]{originalFileName});
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        LOGGER.debug("atr xml fileName: {}", (Object)originalFileName);
        return this.archivesSearchExternalService.transferAcknowledgment(inputStream, originalFileName);
    }

    @GetMapping(value={"/external-ontologies"})
    @Secured(value={"ROLE_GET_ARCHIVE_SEARCH"})
    public List<VitamUiOntologyDto> getExternalOntologiesList() {
        LOGGER.debug("[EXTERNAL] : Get External ontologies list");
        return this.archivesSearchExternalService.getExternalOntologiesList();
    }

    @GetMapping(value={"/units-by-persistent-identifier"})
    public PersistentIdentifierResponseDto findUnitsByPersistentIdentifier(@RequestParam(value="id") String arkId) {
        LOGGER.debug("[EXTERNAL] : Get units by persistent identifier {}", (Object)arkId);
        PersistentIdentifierResponseDto persistentIdentifierResponse = this.archivesSearchExternalService.findUnitsByPersistentIdentifier(arkId);
        LOGGER.debug("[EXTERNAL] : persistentIdentifierResponse = {}", (Object)persistentIdentifierResponse);
        return persistentIdentifierResponse;
    }

    @GetMapping(value={"/objects-by-persistent-identifier"})
    public PersistentIdentifierResponseDto findObjectsByPersistentIdentifier(@RequestParam(value="id") String arkId) {
        LOGGER.debug("[EXTERNAL] : Get objects by persistent identifier {}", (Object)arkId);
        PersistentIdentifierResponseDto persistentIdentifierResponse = this.archivesSearchExternalService.findObjectsByPersistentIdentifier(arkId);
        LOGGER.debug("[EXTERNAL] : persistentIdentifierResponse = {}", (Object)persistentIdentifierResponse);
        return persistentIdentifierResponse;
    }
}

