/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.service;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.authentication.InternalAuthentication;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class InternalSecurityService {
    public boolean isLevelAllowed(String childLevel) {
        if (childLevel == null) {
            throw new IllegalArgumentException("childLevel is not defined");
        }
        String parentLevel = this.getLevel();
        return parentLevel.isEmpty() || childLevel.startsWith(parentLevel + ".");
    }

    public boolean userIsRootLevel() {
        return StringUtils.equals((CharSequence)this.getLevel(), (CharSequence)"");
    }

    private InternalAuthentication getAuthentication() {
        InternalAuthentication authentication = (InternalAuthentication)SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnAuthorizedException("Unable to get the security context. You probably are not authenticated.");
        }
        return authentication;
    }

    public String getLevel() {
        String level = this.getAuthentication().getCredentials().getUserLevel();
        if (level == null) {
            throw new ApplicationServerException("Level not found in security context");
        }
        return level;
    }

    public Integer getProofTenantIdentifier() {
        Integer tenantIdentifier = this.getAuthentication().getPrincipal().getProofTenantIdentifier();
        if (tenantIdentifier == null) {
            throw new ApplicationServerException("Proof tenant identifier not found in security context");
        }
        return tenantIdentifier;
    }

    public String getCustomerId() {
        String customerId = this.getAuthentication().getCredentials().getCustomerId();
        if (customerId == null) {
            throw new ApplicationServerException("Customer not found in security context");
        }
        return customerId;
    }

    public Integer getTenantIdentifier() {
        Integer tenantIdentifier = this.getAuthentication().getCredentials().getTenantIdentifier();
        if (tenantIdentifier == null) {
            throw new ApplicationServerException("Tenant not found in security context");
        }
        return tenantIdentifier;
    }

    public String getApplicationId() {
        String applicationId = this.getAuthentication().getCredentials().getApplicationId();
        if (applicationId == null) {
            throw new ApplicationServerException("Application ID not found in security context");
        }
        return applicationId;
    }

    public String getRequestId() {
        String requestId = this.getAuthentication().getCredentials().getRequestId();
        if (requestId == null) {
            throw new ApplicationServerException("Request ID not found in security context");
        }
        return requestId;
    }

    public String getUserToken() {
        String userToken = this.getAuthentication().getCredentials().getUserToken();
        if (userToken == null) {
            throw new ApplicationServerException("Token not found in security context");
        }
        return userToken;
    }

    public AuthUserDto getUser() {
        AuthUserDto user = this.getAuthentication().getPrincipal();
        if (user == null) {
            throw new ApplicationServerException("User not found in security context");
        }
        return user;
    }

    public InternalHttpContext getHttpContext() {
        InternalHttpContext httpContext = this.getAuthentication().getCredentials();
        if (httpContext == null) {
            throw new ApplicationServerException("HttpContext not found in security context");
        }
        return httpContext;
    }

    public static List<Role> getRoles(AuthUserDto user) {
        if (user.getProfileGroup() == null) {
            return Collections.emptyList();
        }
        List profiles = user.getProfileGroup().getProfiles();
        return profiles == null || profiles.size() == 0 ? Collections.emptyList() : profiles.stream().filter(ProfileDto::isEnabled).flatMap(p -> p.getRoles().stream()).collect(Collectors.toList());
    }

    public static List<Role> getRoles(AuthUserDto user, Integer tenantIdentifier) {
        if (user.getProfileGroup() == null) {
            return Collections.emptyList();
        }
        List profiles = user.getProfileGroup().getProfiles();
        return profiles == null || profiles.size() == 0 ? Collections.emptyList() : profiles.stream().filter(ProfileDto::isEnabled).filter(p -> tenantIdentifier.equals(p.getTenantIdentifier())).flatMap(p -> p.getRoles().stream()).collect(Collectors.toList());
    }

    public TenantDto getTenant(Integer tenantIdentifier) {
        Optional<TenantDto> tenant = this.getUser().getTenantsByApp().stream().flatMap(t -> t.getTenants().stream()).filter(t -> tenantIdentifier.equals(t.getIdentifier())).findAny();
        return tenant.orElseThrow(() -> new ApplicationServerException("Tenant not found"));
    }

    public TenantDto getCurrentTenantDto() {
        return this.getTenant(this.getTenantIdentifier());
    }

    public VitamContext getVitamContext() {
        return this.buildVitamContext(this.getTenantIdentifier());
    }

    public VitamContext buildVitamContext(Integer tenantId) {
        return new VitamContext(tenantId).setApplicationSessionId(this.getApplicationId());
    }

    public VitamContext buildVitamContext(Integer tenantId, String accessContractId) {
        return new VitamContext(tenantId).setAccessContract(accessContractId).setApplicationSessionId(this.getApplicationId());
    }

    public boolean hasRole(String role) {
        AuthUserDto user = this.getAuthentication().getPrincipal();
        List<Role> roles = InternalSecurityService.getRoles(user);
        return roles != null && roles.stream().anyMatch(r -> r.getName().equals(role));
    }
}

