/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.service;

import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.authentication.ExternalAuthentication;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.context.SecurityContextHolder;

public class ExternalSecurityService {
    public ExternalAuthentication getAuthentication() {
        ExternalAuthentication authentication = (ExternalAuthentication)SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnAuthorizedException("Unable to get the security context. You probably are not authenticated.");
        }
        return authentication;
    }

    public boolean canAccessToAllTenants() {
        return this.getAuthentication().getAuthorities().stream().anyMatch(r -> r.getAuthority().equalsIgnoreCase("ROLE_GET_ALL_TENANTS"));
    }

    public boolean canAccessAllCustomersTenants() {
        return this.getAuthentication().getAuthorities().stream().anyMatch(r -> r.getAuthority().equalsIgnoreCase("ROLE_GET_TENANTS"));
    }

    public boolean hasRole(String role) {
        AuthUserDto user = this.getAuthentication().getPrincipal();
        List<Role> roles = InternalSecurityService.getRoles(user);
        return roles == null ? false : roles.stream().anyMatch(r -> r.getName().equalsIgnoreCase(role));
    }

    public Integer getTenantIdentifier() {
        Integer tenantIdentifier = this.getAuthentication().getCredentials().getTenantIdentifier();
        if (tenantIdentifier == null) {
            throw new ApplicationServerException("Tenant not found in security context");
        }
        return tenantIdentifier;
    }

    public boolean isLevelAllowed(String childLevel) {
        if (childLevel == null) {
            throw new IllegalArgumentException("childLevel is node defined");
        }
        String parentLevel = this.getLevel();
        return parentLevel.isEmpty() || childLevel.startsWith(parentLevel + ".");
    }

    public String getLevel() {
        return this.getUser().getLevel();
    }

    public String getCustomerId() {
        return this.getUser().getCustomerId();
    }

    public AuthUserDto getUser() {
        AuthUserDto user = this.getAuthentication().getPrincipal();
        if (user == null) {
            throw new ApplicationServerException("User not found in security context");
        }
        return user;
    }

    public ExternalHttpContext getHttpContext() {
        ExternalHttpContext httpContext = this.getAuthentication().getCredentials();
        if (httpContext == null) {
            throw new ApplicationServerException("HttpContext not found in security context");
        }
        return httpContext;
    }

    public Integer getProofTenantIdentifier() {
        Integer tenantIdentifier = this.getAuthentication().getPrincipal().getProofTenantIdentifier();
        if (tenantIdentifier == null) {
            throw new ApplicationServerException("Proof tenant identifier not found in security context");
        }
        return tenantIdentifier;
    }

    public TenantDto getCurrentTenantDto() {
        return this.getTenant(this.getTenantIdentifier());
    }

    public TenantDto getTenant(Integer tenantIdentifier) {
        Optional<TenantDto> tenant = this.getUser().getTenantsByApp().stream().flatMap(t -> t.getTenants().stream()).filter(t -> tenantIdentifier.equals(t.getIdentifier())).findAny();
        tenant.orElseThrow(() -> new ApplicationServerException("Tenant not found"));
        return tenant.get();
    }

    public String getApplicationId() {
        String applicationId = this.getAuthentication().getCredentials().getApplicationId();
        if (applicationId == null) {
            throw new ApplicationServerException("Application ID not found in security context");
        }
        return applicationId;
    }

    public String getRequestId() {
        String requestId = this.getAuthentication().getCredentials().getRequestId();
        if (requestId == null) {
            throw new ApplicationServerException("Request ID not found in security context");
        }
        return requestId;
    }

    public boolean userIsRootLevel() {
        return StringUtils.equals((CharSequence)this.getLevel(), (CharSequence)"");
    }

    public InternalHttpContext getInternalHttpContext() {
        return InternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)this.getHttpContext());
    }
}

