/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.provider;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.authentication.InternalAuthentication;
import fr.gouv.vitamui.iam.security.service.InternalAuthentificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class InternalApiAuthenticationProvider
implements AuthenticationProvider {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(InternalApiAuthenticationProvider.class);
    private final InternalAuthentificationService internalAuthentificationService;

    @Autowired
    public InternalApiAuthenticationProvider(InternalAuthentificationService internalAuthentificationService) {
        this.internalAuthentificationService = internalAuthentificationService;
    }

    public Authentication authenticate(Authentication authentication) {
        if (this.supports(authentication.getClass())) {
            PreAuthenticatedAuthenticationToken token = (PreAuthenticatedAuthenticationToken)authentication;
            InternalHttpContext principal = (InternalHttpContext)token.getPrincipal();
            LOGGER.debug("Principal: {}", (Object)principal);
            if (principal != null) {
                AuthUserDto userProfile = this.internalAuthentificationService.getUserFromHttpContext(principal);
                return new InternalAuthentication(userProfile, principal);
            }
        }
        throw new BadCredentialsException("Unable to authenticate REST call");
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }
}

