/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.provider;

import fr.gouv.vitamui.commons.api.exception.InvalidAuthenticationException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.authentication.ExternalAuthentication;
import fr.gouv.vitamui.iam.security.service.ExternalAuthentificationService;
import fr.gouv.vitamui.security.common.dto.ContextDto;
import java.security.cert.X509Certificate;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class ExternalApiAuthenticationProvider
implements AuthenticationProvider {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExternalApiAuthenticationProvider.class);
    private final ExternalAuthentificationService extAuthService;

    @Autowired
    public ExternalApiAuthenticationProvider(ExternalAuthentificationService externalAuthenticationService) {
        this.extAuthService = externalAuthenticationService;
    }

    public Authentication authenticate(Authentication authentication) {
        if (this.supports(authentication.getClass())) {
            PreAuthenticatedAuthenticationToken token = (PreAuthenticatedAuthenticationToken)authentication;
            ExternalHttpContext httpContext = (ExternalHttpContext)token.getPrincipal();
            X509Certificate certificate = (X509Certificate)token.getCredentials();
            LOGGER.debug("Principal: {}", (Object)httpContext);
            LOGGER.debug("Credential not null?: {}", (Object)(certificate != null ? 1 : 0));
            if (httpContext != null && certificate != null) {
                try {
                    ContextDto context = this.extAuthService.getContextFromHttpContext(httpContext, certificate);
                    AuthUserDto userDto = this.getAuthenticateUser(httpContext);
                    Integer tenantIdentifier = httpContext.getTenantIdentifier();
                    List<String> intersectionRoles = this.extAuthService.getRoles(context, userDto, tenantIdentifier);
                    String applicationId = this.extAuthService.buildApplicationId(userDto, httpContext, context);
                    ExternalHttpContext newHttpContext = ExternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)httpContext, (String)applicationId);
                    return new ExternalAuthentication(userDto, newHttpContext, certificate, intersectionRoles);
                }
                catch (InvalidAuthenticationException vitamuiException) {
                    throw new BadCredentialsException(vitamuiException.getMessage());
                }
            }
        }
        throw new BadCredentialsException("Unable to authenticate REST call");
    }

    private AuthUserDto getAuthenticateUser(ExternalHttpContext httpContext) {
        AuthUserDto userDto = this.supportsCrossTenants(httpContext) ? this.extAuthService.getAuthenticatedUser(httpContext) : this.extAuthService.getUserFromHttpContext(httpContext);
        return userDto;
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(PreAuthenticatedAuthenticationToken.class);
    }

    public boolean supportsCrossTenants(ExternalHttpContext context) {
        return false;
    }
}

