/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.filter;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.security.filter.X509CertificateExtractor;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;

public class RequestAttributeX509CertificateExtractor
implements X509CertificateExtractor {
    public static final String REQUEST_X509_CERTIFICATE_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(RequestAttributeX509CertificateExtractor.class);

    @Override
    public X509Certificate extract(HttpServletRequest request) {
        X509Certificate[] certificates = (X509Certificate[])request.getAttribute(REQUEST_X509_CERTIFICATE_ATTRIBUTE);
        if (certificates != null && certificates.length > 0) {
            LOGGER.debug("X.509 client authentication certificate:" + certificates[0]);
            return certificates[0];
        }
        LOGGER.debug("No client certificate found in request.");
        return null;
    }
}

