/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.config;

import fr.gouv.vitamui.commons.rest.RestExceptionHandler;
import fr.gouv.vitamui.iam.security.config.AbstractApiWebSecurityConfig;
import fr.gouv.vitamui.iam.security.filter.ExternalRequestHeadersAuthenticationFilter;
import fr.gouv.vitamui.iam.security.filter.TokenExtractor;
import fr.gouv.vitamui.iam.security.filter.X509CertificateExtractor;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class ExternalApiWebSecurityConfig
extends AbstractApiWebSecurityConfig {
    private static final String GATEWAY_ENABLED = "gateway.enabled";
    private static final String CLIENT_CERTIFICATE_HEADER_NAME = "server.ssl.client-certificate-header-name";
    private final boolean isGatewayEnabled;

    public ExternalApiWebSecurityConfig(AuthenticationProvider apiAuthenticationProvider, RestExceptionHandler restExceptionHandler, Environment env) {
        super(apiAuthenticationProvider, restExceptionHandler, env);
        this.isGatewayEnabled = (Boolean)env.getProperty(GATEWAY_ENABLED, Boolean.class, (Object)false);
    }

    @Override
    protected AbstractPreAuthenticatedProcessingFilter getRequestHeadersAuthenticationFilter() throws Exception {
        return new ExternalRequestHeadersAuthenticationFilter(this.authenticationManager(), this.getX509CertificateExtractors(), this.getTokenExtractors());
    }

    private List<X509CertificateExtractor> getX509CertificateExtractors() {
        ArrayList<X509CertificateExtractor> x509CertificateExtractors = new ArrayList<X509CertificateExtractor>();
        x509CertificateExtractors.add(X509CertificateExtractor.requestAttributeX509CertificateExtractor());
        if (this.isGatewayEnabled) {
            String certificateHeaderName = this.env.getProperty(CLIENT_CERTIFICATE_HEADER_NAME);
            x509CertificateExtractors.add(X509CertificateExtractor.requestHeaderX509CertificateExtractor(certificateHeaderName));
        }
        return x509CertificateExtractors;
    }

    private List<TokenExtractor> getTokenExtractors() {
        ArrayList<TokenExtractor> tokenExtractors = new ArrayList<TokenExtractor>();
        tokenExtractors.add(TokenExtractor.headerExtractor("X-User-Token"));
        if (this.isGatewayEnabled) {
            tokenExtractors.add(TokenExtractor.bearerExtractor());
        }
        return tokenExtractors;
    }

    @Generated
    public boolean isGatewayEnabled() {
        return this.isGatewayEnabled;
    }
}

