/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.QueryOperator;
import fr.gouv.vitamui.commons.api.domain.RequestParamDto;
import fr.gouv.vitamui.commons.api.domain.ResultsDto;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractInternalClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public abstract class AbstractResourceClientService<E extends IdDto, I extends IdDto>
extends AbstractInternalClientService {
    protected static final String EXTERNAL_PARAM_ID_KEY = "externalParamId";
    protected static final String TENANT_IDENTIFIER_KEY = "tenantIdentifier";
    protected static final String CUSTOMER_ID_KEY = "customerId";
    protected static final String LEVEL_KEY = "level";
    protected static final String CRITERIA_VERSION_V1 = "v1";
    protected static final String CRITERIA_VERSION_V2 = "v2";

    protected AbstractResourceClientService(ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
    }

    protected E create(E dto) {
        ApiUtils.checkValidity(dto);
        return this.converterToExternalDto(this.getClient().create((AbstractHttpContext)this.getInternalHttpContext(), this.converterToInternalDto(dto)));
    }

    protected E patch(Map<String, Object> partialDto) {
        return this.converterToExternalDto(this.getClient().patch((AbstractHttpContext)this.getInternalHttpContext(), partialDto));
    }

    protected E patchWithDto(I partialDto) {
        return this.converterToExternalDto(this.getClient().patchWithDto((AbstractHttpContext)this.getInternalHttpContext(), partialDto));
    }

    protected E getOne(String id) {
        Optional criteria = this.addAccessRestriction(new QueryDto()).toOptionalJson();
        return this.converterToExternalDto(this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id, criteria));
    }

    protected E getOne(String id, Optional<String> embedded) {
        Optional criteria = this.addAccessRestriction(new QueryDto()).toOptionalJson();
        return this.converterToExternalDto(this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id, criteria, embedded));
    }

    protected PaginatedValuesDto<E> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, this.checkAuthorization(criteria), orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(this::converterToExternalDto).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    protected PaginatedValuesDto<E> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> embedded) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, this.checkAuthorization(criteria), orderBy, direction, embedded);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(this::converterToExternalDto).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    protected ResultsDto<E> getAllRequest(RequestParamDto requestParamDto) {
        ParameterChecker.checkPagination((Integer)requestParamDto.getSize(), (Integer)requestParamDto.getPage());
        requestParamDto.setCriteria(this.checkRequestAuthorization(requestParamDto).orElseGet(null));
        ResultsDto result = this.getClient().getAllRequest((AbstractHttpContext)this.getInternalHttpContext(), requestParamDto);
        return new ResultsDto((Collection)result.getValues().stream().map(this::converterToExternalDto).collect(Collectors.toList()), result);
    }

    protected Optional<String> checkAuthorization(Optional<String> criteria) throws InvalidFormatException {
        return this.addAccessRestriction(QueryDto.fromJson(criteria)).toOptionalJson();
    }

    protected Optional<String> checkRequestAuthorization(RequestParamDto requestParamDto) throws InvalidFormatException {
        if (requestParamDto.getGroups() != null && requestParamDto.getGroups().getFields() != null) {
            for (String aggregateField : requestParamDto.getGroups().getFields()) {
                if (this.getAllowedAggregationKeys().contains(aggregateField)) continue;
                throw new ForbiddenException(String.format("Not allowed to get aggregation %s values", aggregateField));
            }
        }
        if (requestParamDto.getExcludeFields() != null) {
            for (String excludeField : requestParamDto.getExcludeFields()) {
                if (this.getAllowedExcludeKeys().contains(excludeField)) continue;
                throw new ForbiddenException(String.format("Not allowed to exclude the field %s", excludeField));
            }
        }
        return this.addAccessRestriction(QueryDto.fromJson((String)requestParamDto.getCriteria())).toOptionalJson();
    }

    protected Optional<QueryDto> checkCriteriaAuthorization(Optional<QueryDto> criteria) throws InvalidFormatException {
        return Optional.of(this.addAccessRestriction(criteria.orElse(new QueryDto())));
    }

    protected QueryDto addAccessRestriction(QueryDto query) {
        if (CRITERIA_VERSION_V1.equals(this.getVersionApiCrtieria())) {
            return this.addAccessRestrictionV1(query);
        }
        if (CRITERIA_VERSION_V2.equals(this.getVersionApiCrtieria())) {
            return this.addAccessRestrictionV2(query);
        }
        throw new NotImplementedException("Unknow version");
    }

    protected QueryDto addAccessRestrictionV2(QueryDto query) {
        this.checkContainsAuthorizedKeys(query);
        QueryDto securedQuery = QueryDto.andQuery();
        query.keyFilter(this.getAllowedKeys());
        this.getRestrictedKeys(query).forEach(key -> this.addAccessRestrictionByKey((String)key, securedQuery));
        securedQuery.addQuery(query);
        return securedQuery;
    }

    private void checkContainsAuthorizedKeys(QueryDto query) {
        query.keyFilter(this.getAllowedKeys());
        if (query.getSubQueries() != null) {
            query.getSubQueries().forEach(this::checkContainsAuthorizedKeys);
        }
    }

    protected QueryDto addAccessRestrictionV1(QueryDto criteria) {
        criteria.keyFilter(this.getAllowedKeys());
        this.getRestrictedKeys().forEach(key -> this.addAccessRestrictionByKey((String)key, criteria));
        if (criteria.getQueryOperator() != null && !QueryOperator.AND.equals((Object)criteria.getQueryOperator())) {
            throw new UnsupportedOperationException("Unsupported operator " + criteria.getQueryOperator() + ". This API only supports the queryOperator \"AND\" on the root query.");
        }
        return criteria;
    }

    protected String getVersionApiCrtieria() {
        return CRITERIA_VERSION_V1;
    }

    protected void addAccessRestrictionByKey(String key, QueryDto criteria) {
        switch (key) {
            case "customerId": {
                this.addCustomerRestriction(criteria);
                break;
            }
            case "tenantIdentifier": {
                this.addTenantIdentifierRestriction(criteria);
                break;
            }
            default: {
                this.addRestriction(key, criteria);
            }
        }
    }

    protected void addRestriction(String key, QueryDto criteria) {
        throw new NotImplementedException("Restriction not defined for key: " + key);
    }

    protected void addTenantIdentifierRestriction(QueryDto criteria) {
        Optional optCriteria = criteria.find(TENANT_IDENTIFIER_KEY);
        if (optCriteria.isPresent()) {
            this.checkTenantIdentifierCriteria((Criterion)optCriteria.get());
        } else {
            criteria.addCriterion(this.getTenantIdentifierRestriction());
        }
    }

    protected void checkTenantIdentifierCriteria(Criterion tenantIdentifierCriteria) {
        if (!CastUtils.toInteger((Object)tenantIdentifierCriteria.getValue()).equals(this.externalSecurityService.getTenantIdentifier()) || !tenantIdentifierCriteria.getOperator().equals((Object)CriterionOperator.EQUALS)) {
            throw new ForbiddenException("tenantIdentifier's criteria is not equal to the tenantIdentifier from context");
        }
    }

    protected void addCustomerRestriction(QueryDto criteria) {
        Optional customerCriteria = criteria.find(CUSTOMER_ID_KEY);
        if (customerCriteria.isPresent()) {
            this.checkCustomerCriteria((Criterion)customerCriteria.get());
        } else {
            criteria.addCriterion(this.getCustomerRestriction());
        }
    }

    protected void checkCustomerCriteria(Criterion customerCriteria) {
        if (!StringUtils.equals((CharSequence)CastUtils.toString((Object)customerCriteria.getValue()), (CharSequence)this.externalSecurityService.getCustomerId()) || !customerCriteria.getOperator().equals((Object)CriterionOperator.EQUALS)) {
            throw new ForbiddenException("customerId's criteria is not equal to the customerId from context");
        }
    }

    protected Collection<String> getRestrictedKeys() {
        return Arrays.asList(CUSTOMER_ID_KEY);
    }

    protected Collection<String> getRestrictedKeys(QueryDto criteria) {
        return this.getRestrictedKeys();
    }

    protected Collection<String> getAllowedKeys() {
        return Collections.emptyList();
    }

    protected Collection<String> getAllowedAggregationKeys() {
        return Collections.emptyList();
    }

    protected Collection<String> getAllowedExcludeKeys() {
        return Collections.emptyList();
    }

    protected Criterion getCustomerRestriction() {
        return new Criterion(CUSTOMER_ID_KEY, (Object)this.externalSecurityService.getCustomerId(), CriterionOperator.EQUALS);
    }

    protected Criterion getTenantIdentifierRestriction() {
        return new Criterion(TENANT_IDENTIFIER_KEY, (Object)this.externalSecurityService.getTenantIdentifier(), CriterionOperator.EQUALS);
    }

    protected E update(E dto) {
        ApiUtils.checkValidity(dto);
        return this.converterToExternalDto(this.getClient().update((AbstractHttpContext)this.getInternalHttpContext(), this.converterToInternalDto(dto)));
    }

    protected List<E> getAll(Optional<String> criteria) {
        return this.getClient().getAll((AbstractHttpContext)this.getInternalHttpContext(), this.checkAuthorization(criteria)).stream().map(this::converterToExternalDto).collect(Collectors.toList());
    }

    protected List<E> getAll(Optional<String> criteria, Optional<String> embedded) {
        return this.getClient().getAll((AbstractHttpContext)this.getInternalHttpContext(), this.checkAuthorization(criteria), embedded).stream().map(this::converterToExternalDto).collect(Collectors.toList());
    }

    protected boolean checkExists(String criteria) {
        return this.getClient().checkExist((AbstractHttpContext)this.getInternalHttpContext(), this.checkAuthorization(Optional.ofNullable(criteria)).get());
    }

    protected void delete(String id) {
        this.getClient().delete((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    protected abstract BasePaginatingAndSortingRestClient<I, InternalHttpContext> getClient();

    protected void checkCustomerId(String customerId, String message) {
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)customerId, (CharSequence)this.externalSecurityService.getCustomerId()), (String)(message + ": customerId " + customerId + " is not allowed"));
    }

    protected void checkTenantIdentifier(Integer tenantIdentifier, String message) {
        Assert.isTrue((boolean)this.externalSecurityService.getTenantIdentifier().equals(tenantIdentifier), (String)(message + ": tenantIdentifier " + tenantIdentifier + " is not allowed"));
    }

    protected void checkLevel(String level, String message) {
        Assert.isTrue((boolean)this.externalSecurityService.isLevelAllowed(level), (String)message);
    }

    protected LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    protected E converterToExternalDto(I internalDto) {
        return (E)internalDto;
    }

    protected I converterToInternalDto(E externalDto) {
        return (I)externalDto;
    }
}

