/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.security.client;

import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.rest.client.BaseRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;

public abstract class AbstractInternalClientService {
    protected final ExternalSecurityService externalSecurityService;

    public AbstractInternalClientService(ExternalSecurityService externalSecurityService) {
        this.externalSecurityService = externalSecurityService;
    }

    protected InternalHttpContext getInternalHttpContext() {
        ExternalHttpContext externalHttpContext = this.externalSecurityService.getHttpContext();
        AuthUserDto user = this.externalSecurityService.getUser();
        String userLevel = user.getLevel();
        if (userLevel == null) {
            throw new ApplicationServerException("Level is null for user " + user.getEmail());
        }
        String customerId = this.externalSecurityService.getUser().getCustomerId();
        return InternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)externalHttpContext, (String)customerId, (String)userLevel);
    }

    protected abstract BaseRestClient<InternalHttpContext> getClient();
}

