/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archives.search.external.client;

import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ArchiveSearchExternalWebClient
extends BaseWebClient<ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchExternalWebClient.class);

    public ArchiveSearchExternalWebClient(WebClient webClient, String baseUrl) {
        super(webClient, baseUrl);
    }

    public String getPathUrl() {
        return "/archives-search";
    }

    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(String id, String usage, Integer version, ExternalHttpContext context) {
        LOGGER.debug("Start downloading Object from unit id : {} usage : {} version : {}", new Object[]{id, usage, version});
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/downloadobjectfromunit/" + id + "?usage=" + usage + "&version=" + version));
        Flux dataBuffer = this.webClient.get().uri(uriBuilder.toUriString(), new Object[0]).headers(this.addHeaders(this.buildHeaders((AbstractHttpContext)context))).retrieve().bodyToFlux(DataBuffer.class);
        return Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noCache())).body((Object)this.convertDataBufferFileToInputStreamResponse(dataBuffer)));
    }
}

