/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.internal.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.domain.AccessContractDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractService;
import fr.gouv.vitamui.ingest.common.dto.AccessContractResponseDto;
import fr.gouv.vitamui.ingest.common.dto.AccessContractVitamDto;
import fr.gouv.vitamui.ingest.internal.server.service.AccessContractConverter;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessContractInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessContractInternalService.class);
    private AccessContractService accessContractService;
    private ObjectMapper objectMapper;
    private AccessContractConverter converter;

    @Autowired
    public AccessContractInternalService(AccessContractService accessContractService, ObjectMapper objectMapper, AccessContractConverter converter) {
        this.accessContractService = accessContractService;
        this.objectMapper = objectMapper;
        this.converter = converter;
    }

    public Optional<AccessContractDto> getOne(VitamContext vitamContext, String identifier) {
        try {
            LOGGER.debug("Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.accessContractService.findAccessContractById(vitamContext, identifier);
            AccessContractResponseDto accessContractResponseDto = (AccessContractResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractResponseDto.class);
            if (CollectionUtils.isEmpty((Collection)accessContractResponseDto.getResults())) {
                return Optional.empty();
            }
            return Optional.of(this.converter.convertVitamToDto((AccessContractVitamDto)accessContractResponseDto.getResults().get(0)));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contrat", e);
        }
    }
}

