/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.ingest.internal.server.rest;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.ingest.external.api.exception.IngestExternalException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.IngestFileGenerationException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.ingest.internal.server.service.IngestInternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ingest"})
@Api(tags={"ingest"}, value="Ingest an SIP", description="Ingest an SIP")
public class IngestInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestInternalController.class);
    private IngestInternalService ingestInternalService;
    private InternalSecurityService securityService;

    @Autowired
    public IngestInternalController(IngestInternalService ingestInternalService, InternalSecurityService securityService) {
        this.ingestInternalService = ingestInternalService;
        this.securityService = securityService;
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws PreconditionFailedException, InvalidParseOperationException, IOException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        SanityChecker.sanitizeCriteria(criteria);
        if (criteria.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)VitamUIUtils.convertObjectFromJson((String)criteria.get(), Object.class));
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ingestInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @GetMapping(value={"/{id}"})
    public LogbookOperationDto getOne(@PathVariable(value="id") String id) throws PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get Ingest Entities for id={} ", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.ingestInternalService.getOne(vitamContext, id);
    }

    @GetMapping(value={"/odtreport/{id}"})
    public ResponseEntity<byte[]> generateODTReport(@PathVariable(value="id") String id) throws IngestFileGenerationException, PreconditionFailedException {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        try {
            ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
            SanityChecker.checkSecureParameter((String[])new String[]{id});
            LOGGER.debug("export ODT report for operation with id :{}", (Object)id);
            byte[] response = this.ingestInternalService.generateODTReport(vitamContext, id);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (IngestFileGenerationException | IOException | URISyntaxException e) {
            LOGGER.error("Error with generating Report : {} ", (Object)e.getMessage());
            throw new IngestFileGenerationException("Unable to generate the ingest report " + (Exception)e);
        }
        catch (PreconditionFailedException exception) {
            LOGGER.error("The id parameter is not valid", (Object)exception.getMessage());
            throw new PreconditionFailedException("The id parameter is not valid", exception.getMessage());
        }
    }

    @ApiOperation(value="Upload an SIP", consumes="application/octet-stream")
    @PostMapping(value={"/upload"}, consumes={"application/octet-stream"})
    public ResponseEntity<Void> streamingUpload(InputStream inputStream, @RequestHeader(value="X-Action") String action, @RequestHeader(value="X-Context-Id") String contextId) throws IngestExternalException, PreconditionFailedException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The action and the context ID are mandatory parameters: ", (String[])new String[]{action, contextId});
        SanityChecker.checkSecureParameter((String[])new String[]{action, contextId});
        LOGGER.debug("[Internal] upload file v2");
        String operationId = this.ingestInternalService.streamingUpload(inputStream, contextId, action);
        if (operationId != null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("X-Operation-Id", new String[]{operationId})).build();
        }
        LOGGER.error("Cannot retrieve operation id");
        throw new IngestExternalException("Cannot retrieve operation id");
    }

    @Generated
    public IngestInternalService getIngestInternalService() {
        return this.ingestInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setIngestInternalService(IngestInternalService ingestInternalService) {
        this.ingestInternalService = ingestInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

