/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NoRightsException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.external.server.service.TenantExternalService;
import fr.gouv.vitamui.iam.internal.client.TenantInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TenantExternalService
extends AbstractResourceClientService<TenantDto, TenantDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TenantExternalService.class);
    private final TenantInternalRestClient tenantInternalRestClient;
    private final String CUSTOMER_INSUFFICIENT_PERMISSION_MESSAGE = "Unable to update the tenant %s: insufficient permissions on customer.";
    private final String TENANT_INSUFFICIENT_PERMISSION_MESSAGE = "Unable to access to the tenant %s: insufficient permissions.";
    private final String ID_KEY = "id";

    @Autowired
    public TenantExternalService(ExternalSecurityService externalSecurityService, TenantInternalRestClient tenantInternalRestClient) {
        super(externalSecurityService);
        this.tenantInternalRestClient = tenantInternalRestClient;
    }

    public TenantDto create(TenantDto dto) {
        LOGGER.debug("Create {}", (Object)dto);
        if (!this.canAccessToCustomer(dto.getCustomerId())) {
            throw new ForbiddenException(String.format("Unable to update the tenant %s: insufficient permissions on customer.", dto.getId()));
        }
        return (TenantDto)super.create((IdDto)dto);
    }

    public TenantDto getOne(String id) {
        return (TenantDto)super.getOne(id);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public TenantDto update(TenantDto tenant) {
        ApiUtils.checkValidity((Object)tenant);
        if (!this.canAccessToTenant(tenant.getIdentifier())) {
            throw new NoRightsException(String.format("Unable to access to the tenant %s: insufficient permissions.", tenant.getId()));
        }
        if (!this.canAccessToCustomer(tenant.getCustomerId())) {
            throw new NoRightsException(String.format("Unable to update the tenant %s: insufficient permissions on customer.", tenant.getId()));
        }
        return (TenantDto)this.getClient().update((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)tenant);
    }

    public TenantDto patch(Map<String, Object> partialDto) {
        String customerId;
        String id = (String)partialDto.get("id");
        TenantDto tenant = (TenantDto)super.getOne(id, Optional.empty());
        if (!this.canAccessToTenant(tenant.getIdentifier())) {
            throw new NoRightsException(String.format("Unable to access to the tenant %s: insufficient permissions.", tenant.getId()));
        }
        if (partialDto.containsKey("customerId") && !this.canAccessToCustomer(customerId = CastUtils.toString((Object)partialDto.get("customerId")))) {
            throw new NoRightsException(String.format("Unable to update the tenant %s: insufficient permissions on customer.", tenant.getId()));
        }
        return (TenantDto)super.patch(partialDto);
    }

    public List<TenantDto> getAll(Optional<String> criteria) {
        return super.getAll(criteria);
    }

    protected boolean canAccessToCustomer(String customerId) {
        return this.externalSecurityService.hasRole("ROLE_UPDATE_TENANTS_ALL_CUSTOMERS") || customerId.equals(this.externalSecurityService.getCustomerId());
    }

    protected boolean canAccessToTenant(Integer tenantIdentifier) {
        if (!this.externalSecurityService.hasRole("ROLE_GET_ALL_TENANTS")) {
            Integer securityTenantIdentifier = this.externalSecurityService.getTenantIdentifier();
            return Objects.equals(securityTenantIdentifier, tenantIdentifier);
        }
        return true;
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("id", "customerId", "enabled", "proof", "name", "identifier", "ownerId");
    }

    protected Collection<String> getRestrictedKeys() {
        ArrayList<String> restrictedKeys = new ArrayList<String>();
        if (!this.externalSecurityService.hasRole("ROLE_GET_ALL_TENANTS")) {
            restrictedKeys.add("customerId");
            if (!this.externalSecurityService.hasRole("ROLE_GET_TENANTS_MY_CUSTOMER")) {
                restrictedKeys.add("identifier");
            }
        }
        return restrictedKeys;
    }

    protected void checkCustomerCriteria(Criterion customerCriteria) {
        Assert.isTrue((boolean)this.canAccessToCustomer(CastUtils.toString((Object)customerCriteria.getValue())), (String)"customerId's criteria is not equal to the customerId from context");
    }

    protected void addRestriction(String key, QueryDto criteria) {
        switch (key) {
            case "identifier": {
                Optional criterionOpt = criteria.find("identifier");
                if (criterionOpt.isPresent()) {
                    this.checkIdentifierCriteria((Criterion)criterionOpt.get());
                    break;
                }
                criteria.addCriterion(this.getIdentifierRestriction());
                break;
            }
            default: {
                throw new NotImplementedException("Restriction not defined for key: " + key);
            }
        }
    }

    private Criterion getIdentifierRestriction() {
        return new Criterion("identifier", (Object)this.externalSecurityService.getTenantIdentifier(), CriterionOperator.EQUALS);
    }

    protected void checkIdentifierCriteria(Criterion identifierCriterion) {
        ArrayList<Integer> identifiers = new ArrayList<Integer>();
        switch (1.$SwitchMap$fr$gouv$vitamui$commons$api$domain$CriterionOperator[identifierCriterion.getOperator().ordinal()]) {
            case 1: {
                identifiers.add(CastUtils.toInteger((Object)identifierCriterion.getValue()));
                break;
            }
            case 2: {
                identifiers.addAll(CastUtils.toList((Object)identifierCriterion.getValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + identifierCriterion.getOperator() + " is not supported for field : identifier");
            }
        }
        List wrongIdentifiers = identifiers.stream().filter(identifier -> this.canAccessToTenant(identifier)).collect(Collectors.toList());
        if (!wrongIdentifiers.isEmpty()) {
            throw new NoRightsException(String.format("Unable to access to the tenant %s: insufficient permissions.", wrongIdentifiers.toString()));
        }
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        this.checkLogbookRight(id);
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public void checkLogbookRight(String id) {
        boolean hasRoleGetTenant = this.externalSecurityService.hasRole("ROLE_GET_TENANTS");
        if (!hasRoleGetTenant && !StringUtils.equals((CharSequence)this.externalSecurityService.getCurrentTenantDto().getId(), (CharSequence)id)) {
            throw new ForbiddenException(String.format("Unable to access tenant with id: %s", id));
        }
        TenantDto tenantDto = (TenantDto)super.getOne(id);
        if (tenantDto == null) {
            throw new ForbiddenException(String.format("Unable to access tenant with id: %s", id));
        }
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    protected TenantInternalRestClient getClient() {
        return this.tenantInternalRestClient;
    }

    @Generated
    public TenantInternalRestClient getTenantInternalRestClient() {
        return this.tenantInternalRestClient;
    }

    @Generated
    public String getCUSTOMER_INSUFFICIENT_PERMISSION_MESSAGE() {
        Objects.requireNonNull(this);
        return "Unable to update the tenant %s: insufficient permissions on customer.";
    }

    @Generated
    public String getTENANT_INSUFFICIENT_PERMISSION_MESSAGE() {
        Objects.requireNonNull(this);
        return "Unable to access to the tenant %s: insufficient permissions.";
    }

    @Generated
    public String getID_KEY() {
        Objects.requireNonNull(this);
        return "id";
    }
}

