/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.exception.InvalidFormatException;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.dto.common.ProviderEmbeddedOptions;
import fr.gouv.vitamui.iam.common.utils.IdentityProviderBuilder;
import fr.gouv.vitamui.iam.external.server.domain.dto.ProviderPatchType;
import fr.gouv.vitamui.iam.external.server.service.IdentityProviderExternalService;
import fr.gouv.vitamui.iam.internal.client.IdentityProviderInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IdentityProviderExternalService
extends AbstractResourceClientService<IdentityProviderDto, IdentityProviderDto> {
    @Autowired
    private final IdentityProviderInternalRestClient identityProviderInternalRestClient;

    public IdentityProviderExternalService(IdentityProviderInternalRestClient identityProviderInternalRestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.identityProviderInternalRestClient = identityProviderInternalRestClient;
    }

    public IdentityProviderDto create(IdentityProviderDto dto) {
        return (IdentityProviderDto)super.create((IdDto)dto);
    }

    public IdentityProviderDto mapToIdentityProviderDto(MultipartFile keystore, MultipartFile idpMetadata, String provider) throws Exception {
        IdentityProviderDto dto = (IdentityProviderDto)new ObjectMapper().readValue(provider, IdentityProviderDto.class);
        IdentityProviderBuilder builder = new IdentityProviderBuilder(dto.getName(), dto.getTechnicalName(), dto.getEnabled(), dto.getInternal(), dto.getPatterns(), (Resource)(Objects.nonNull(keystore) ? new ByteArrayResource(keystore.getBytes()) : null), dto.getKeystorePassword(), dto.getPrivateKeyPassword(), (Resource)(Objects.nonNull(idpMetadata) ? new ByteArrayResource(idpMetadata.getBytes()) : null), dto.getCustomerId(), Boolean.valueOf(dto.isReadonly()), dto.getMailAttribute(), dto.getIdentifierAttribute(), dto.getMaximumAuthenticationLifetime(), dto.getAuthnRequestBinding(), Boolean.valueOf(Objects.isNull(dto.getWantsAssertionsSigned()) ? true : dto.getWantsAssertionsSigned()), Boolean.valueOf(Objects.isNull(dto.getAuthnRequestSigned()) ? true : dto.getAuthnRequestSigned()), dto.isPropagateLogout(), Boolean.valueOf(dto.isAutoProvisioningEnabled()), dto.getClientId(), dto.getClientSecret(), dto.getDiscoveryUrl(), dto.getScope(), dto.getPreferredJwsAlgorithm(), dto.getCustomParams(), dto.getUseState(), dto.getUseNonce(), dto.getUsePkce(), dto.getProtocoleType());
        return builder.build();
    }

    public IdentityProviderDto patch(Map<String, Object> partialDto) {
        return (IdentityProviderDto)super.patch(partialDto);
    }

    protected void beforePatch(Map<String, Object> partialDto, MultipartFile keystore, MultipartFile idpMetadata, String id, ProviderPatchType patchType) {
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for patch.");
        switch (1.$SwitchMap$fr$gouv$vitamui$iam$external$server$domain$dto$ProviderPatchType[patchType.ordinal()]) {
            case 1: {
                Assert.isTrue((StringUtils.isNotEmpty((CharSequence)((String)partialDto.get("keystorePassword"))) && !keystore.isEmpty() ? 1 : 0) != 0, (String)"The keystorePassword is missing");
                break;
            }
            case 2: {
                Assert.isTrue((!idpMetadata.isEmpty() ? 1 : 0) != 0, (String)"idpMetadata is missing");
                break;
            }
        }
    }

    public IdentityProviderDto patch(Map<String, Object> partialDto, MultipartFile keystore, MultipartFile idpMetadata, String id, ProviderPatchType patchType) {
        this.beforePatch(partialDto, keystore, idpMetadata, id, patchType);
        switch (1.$SwitchMap$fr$gouv$vitamui$iam$external$server$domain$dto$ProviderPatchType[patchType.ordinal()]) {
            case 1: {
                String keystoreBase64 = this.getKeystoreBase64(keystore);
                partialDto.put("keystoreBase64", keystoreBase64);
                break;
            }
            case 2: {
                String idpMetadataFormatter = this.getIdpMetadata(idpMetadata);
                partialDto.put("idpMetadata", idpMetadataFormatter);
                break;
            }
        }
        return this.convertDtoFromApi((IdentityProviderDto)super.patch(partialDto));
    }

    private String getKeystoreBase64(MultipartFile keystoreFile) {
        String string;
        block8: {
            InputStream isKeystore = keystoreFile.getInputStream();
            try {
                byte[] keystore = IOUtils.toByteArray((InputStream)isKeystore);
                string = new String(Base64.getEncoder().encode(keystore), StandardCharsets.UTF_8);
                if (isKeystore == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (isKeystore != null) {
                        try {
                            isKeystore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidFormatException("Keystore is unreadable");
                }
            }
            isKeystore.close();
        }
        return string;
    }

    private String getIdpMetadata(MultipartFile idpMetadata) {
        String string;
        block8: {
            InputStream isIdpMeta = idpMetadata.getInputStream();
            try {
                string = IOUtils.toString((InputStream)isIdpMeta);
                if (isIdpMeta == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (isIdpMeta != null) {
                        try {
                            isIdpMeta.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidFormatException("IdpMetadata is unreadable");
                }
            }
            isIdpMeta.close();
        }
        return string;
    }

    protected IdentityProviderDto convertDtoFromApi(IdentityProviderDto apiDto) {
        IdentityProviderDto dto = new IdentityProviderDto();
        VitamUIUtils.copyProperties((Object)apiDto, (Object)dto);
        this.convertPatterns(dto);
        return dto;
    }

    private void convertPatterns(IdentityProviderDto dto) {
        if (CollectionUtils.isNotEmpty((Collection)dto.getPatterns())) {
            dto.setPatterns(dto.getPatterns().stream().map(s -> s.replace(".*@", "")).collect(Collectors.toList()));
        }
    }

    public Resource getMetadataProviderByProviderId(String id, ProviderEmbeddedOptions option, Optional<String> embedded) {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        IdentityProviderDto dto = this.getOne(id, embedded);
        return new ByteArrayResource(ProviderEmbeddedOptions.IDPMETADATA.equals((Object)option) ? dto.getIdpMetadata().getBytes() : dto.getSpMetadata().getBytes());
    }

    public IdentityProviderDto getOne(String id, Optional<String> embedded) {
        return (IdentityProviderDto)super.getOne(id, embedded);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public List<IdentityProviderDto> getAll(Optional<String> criteria, Optional<String> embedded) {
        return super.getAll(criteria, embedded);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("id", "name", "internal", "enabled", "patterns", "customerId");
    }

    protected Collection<String> getRestrictedKeys() {
        return Collections.emptyList();
    }

    protected IdentityProviderInternalRestClient getClient() {
        return this.identityProviderInternalRestClient;
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    @Generated
    public IdentityProviderInternalRestClient getIdentityProviderInternalRestClient() {
        return this.identityProviderInternalRestClient;
    }
}

