/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.QueryOperator;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.internal.client.GroupInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GroupExternalService
extends AbstractResourceClientService<GroupDto, GroupDto> {
    private static final String IDENTIFIER_KEY = "identifier";
    private static final String ID_KEY = "id";
    private static final String NAME_KEY = "name";
    private static final String ENABLED_KEY = "enabled";
    private static final String DESCRIPTION_KEY = "description";
    private static final String UNITS_KEY = "units";
    private static final String READONLY_KEY = "readonly";
    private final GroupInternalRestClient groupInternalRestClient;

    @Autowired
    public GroupExternalService(GroupInternalRestClient groupInternalRestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.groupInternalRestClient = groupInternalRestClient;
    }

    public GroupDto create(GroupDto dto) {
        this.checkCustomerId(dto.getCustomerId(), "Unable to create group");
        return (GroupDto)super.create((IdDto)dto);
    }

    public GroupDto patch(Map<String, Object> partialDto) {
        String customerId = (String)partialDto.get("customerId");
        String level = CastUtils.toString((Object)partialDto.get("level"));
        if (StringUtils.isNotEmpty((CharSequence)customerId)) {
            this.checkCustomerId(customerId, "Unable to patch group");
        }
        if (StringUtils.isNotEmpty((CharSequence)level)) {
            this.checkLevel(level, "Unable to patch profile");
        }
        partialDto.put("customerId", this.externalSecurityService.getCustomerId());
        return (GroupDto)super.patch(partialDto);
    }

    public GroupDto getOne(String id, Optional<String> embedded) {
        return (GroupDto)super.getOne(id, embedded);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public List<GroupDto> getAll(Optional<String> criteria, Optional<String> embedded) {
        return super.getAll(criteria, embedded);
    }

    public PaginatedValuesDto<GroupDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> embedded) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
    }

    public Collection<String> getAllowedKeys() {
        return Arrays.asList(ID_KEY, IDENTIFIER_KEY, NAME_KEY, ENABLED_KEY, DESCRIPTION_KEY, "level", "customerId", UNITS_KEY, READONLY_KEY);
    }

    protected void addRestriction(String key, QueryDto query) {
        switch (key) {
            case "level": {
                this.addLevelRestriction(query);
                break;
            }
            default: {
                throw new NotImplementedException("Restriction not defined for key: " + key);
            }
        }
    }

    private void addLevelRestriction(QueryDto query) {
        QueryDto levelQuery = new QueryDto();
        levelQuery.setQueryOperator(QueryOperator.OR);
        levelQuery.addCriterion("level", (Object)(this.externalSecurityService.getLevel() + "."), CriterionOperator.STARTWITH);
        levelQuery.addCriterion(ID_KEY, (Object)this.externalSecurityService.getUser().getProfileGroup().getId(), CriterionOperator.EQUALS);
        query.addQuery(levelQuery);
    }

    protected Collection<String> getRestrictedKeys() {
        ArrayList<String> restrictedKeys = new ArrayList<String>(Arrays.asList("customerId", "level"));
        if (this.externalSecurityService.userIsRootLevel()) {
            restrictedKeys.remove("level");
        }
        return restrictedKeys;
    }

    protected GroupInternalRestClient getClient() {
        return this.groupInternalRestClient;
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        this.checkLogbookRight(id);
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public void checkLogbookRight(String id) {
        boolean hasRoleGetGroups = this.externalSecurityService.hasRole("ROLE_GET_GROUPS");
        if (!hasRoleGetGroups && !StringUtils.equals((CharSequence)this.externalSecurityService.getUser().getGroupId(), (CharSequence)id)) {
            throw new ForbiddenException(String.format("Unable to access group with id: %s", id));
        }
        GroupDto groupDto = (GroupDto)super.getOne(id);
        if (groupDto == null) {
            throw new ForbiddenException(String.format("Unable to access group with id: %s", id));
        }
    }

    public List<String> getLevels(Optional<String> criteria) {
        return this.getClient().getLevels(this.getInternalHttpContext(), this.checkAuthorization(criteria));
    }

    public ResponseEntity<Resource> exportProfileGroups() {
        return this.getClient().exportProfileGroups(this.getInternalHttpContext(), this.checkAuthorization(Optional.empty()));
    }

    @Generated
    public GroupInternalRestClient getGroupInternalRestClient() {
        return this.groupInternalRestClient;
    }
}

