/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.common.dto.CustomerCreationFormData;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.CustomerPatchFormData;
import fr.gouv.vitamui.iam.internal.client.CustomerInternalRestClient;
import fr.gouv.vitamui.iam.internal.client.CustomerInternalWebClient;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CustomerExternalService
extends AbstractResourceClientService<CustomerDto, CustomerDto> {
    private final CustomerInternalRestClient customerInternalRestClient;
    private final CustomerInternalWebClient customerInternalV2RestClient;

    @Autowired
    public CustomerExternalService(CustomerInternalRestClient customerInternalRestClient, CustomerInternalWebClient customerInternalV2RestClient, ExternalSecurityService externalSecurityService) {
        super(externalSecurityService);
        this.customerInternalRestClient = customerInternalRestClient;
        this.customerInternalV2RestClient = customerInternalV2RestClient;
    }

    public CustomerDto create(CustomerCreationFormData customerData) {
        return this.customerInternalV2RestClient.create(this.getInternalHttpContext(), customerData);
    }

    public CustomerDto patch(CustomerPatchFormData customerData) {
        return this.customerInternalV2RestClient.patch(this.getInternalHttpContext(), customerData);
    }

    public CustomerDto update(CustomerDto dto) {
        return (CustomerDto)super.update((IdDto)dto);
    }

    public CustomerDto patch(Map<String, Object> partialDto) {
        return (CustomerDto)super.patch(partialDto);
    }

    public CustomerDto getOne(String id) {
        return (CustomerDto)super.getOne(id);
    }

    public List<CustomerDto> getAll(Optional<String> criteria) {
        return super.getAll(criteria);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public PaginatedValuesDto<CustomerDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        return super.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    public CustomerDto getByCode(String code) {
        return this.getClient().getByCode(this.getInternalHttpContext(), code);
    }

    public CustomerDto getMyCustomer() {
        return this.getClient().getMyCustomer(this.getInternalHttpContext());
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("id", "name", "code", "companyName", "enabled", "language", "otp", "defaultEmailDomain", "emailDomains", "subrogeable");
    }

    protected Collection<String> getRestrictedKeys() {
        return Collections.emptyList();
    }

    protected CustomerInternalRestClient getClient() {
        return this.customerInternalRestClient;
    }

    protected String getVersionApiCrtieria() {
        return "v2";
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        this.checkLogbookRight(id);
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public void checkLogbookRight(String id) {
        boolean hasRoleGetCustomers = this.externalSecurityService.hasRole("ROLE_GET_CUSTOMERS");
        if (!hasRoleGetCustomers && !StringUtils.equals((CharSequence)this.externalSecurityService.getUser().getCustomerId(), (CharSequence)id)) {
            throw new ForbiddenException(String.format("Unable to access customer with id: %s", id));
        }
        CustomerDto customerDto = (CustomerDto)super.getOne(id);
        if (customerDto == null) {
            throw new ForbiddenException(String.format("Unable to access customer with id: %s", id));
        }
    }

    public ResponseEntity<Resource> getLogo(String id, AttachmentType type) {
        return this.getClient().getLogo(this.getInternalHttpContext(), id, type);
    }

    public boolean getGdprSettingStatus() {
        return this.getClient().getGdprSettingStatus(this.getInternalHttpContext());
    }

    @Generated
    public CustomerInternalRestClient getCustomerInternalRestClient() {
        return this.customerInternalRestClient;
    }

    @Generated
    public CustomerInternalWebClient getCustomerInternalV2RestClient() {
        return this.customerInternalV2RestClient;
    }
}

