/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.dto.cas.LoginRequestDto;
import fr.gouv.vitamui.iam.internal.client.CasInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractInternalClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CasExternalService
extends AbstractInternalClientService {
    private final CasInternalRestClient casInternalRestClient;
    private final ExternalSecurityService securityService;

    @Autowired
    public CasExternalService(CasInternalRestClient casInternalRestClient, ExternalSecurityService securityService) {
        super(securityService);
        this.casInternalRestClient = casInternalRestClient;
        this.securityService = securityService;
    }

    public void changePassword(String username, String password, String customerId) {
        this.getClient().changePassword(this.getInternalHttpContext(), username, password, customerId);
    }

    public UserDto login(LoginRequestDto dto) {
        return this.getClient().login(this.getInternalHttpContext(), dto);
    }

    public List<? extends UserDto> getUsersByEmail(String email, Optional<String> embedded) {
        return this.getClient().getUsersByEmail(this.getInternalHttpContext(), email, embedded);
    }

    public UserDto getUser(String loginEmail, String loginCustomerId, String idp, Optional<String> userIdentifier, Optional<String> optEmbedded) {
        return this.getClient().getUser(this.getInternalHttpContext(), loginEmail, loginCustomerId, idp, userIdentifier, optEmbedded);
    }

    public UserDto getUserById(String id) {
        return this.getClient().getUserById(this.getInternalHttpContext(), id);
    }

    public List<SubrogationDto> getSubrogationsBySuperUserAndCustomerId(String superUserEmail, String superUserCustomerId) {
        return this.getClient().getSubrogationsBySuperUserEmailAndCustomerId(this.getInternalHttpContext(), superUserEmail, superUserCustomerId);
    }

    public List<SubrogationDto> getSubrogationsBySuperUserId(String superUserId) {
        return this.getClient().getSubrogationsBySuperUserId(this.getInternalHttpContext(), superUserId);
    }

    public void logout(String authToken, String superUser, String superUserCustomerId) {
        this.getClient().logout(this.getInternalHttpContext(), authToken, superUser, superUserCustomerId);
    }

    protected CasInternalRestClient getClient() {
        return this.casInternalRestClient;
    }

    public Collection<CustomerDto> getCustomersByIds(List<String> customerIds) {
        return this.getClient().getCustomersByIds(this.getInternalHttpContext(), customerIds);
    }

    @Generated
    public CasInternalRestClient getCasInternalRestClient() {
        return this.casInternalRestClient;
    }

    @Generated
    public ExternalSecurityService getSecurityService() {
        return this.securityService;
    }
}

