/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.service;

import fr.gouv.vitamui.commons.api.domain.Criterion;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.domain.QueryOperator;
import fr.gouv.vitamui.iam.external.server.service.ApplicationExternalService;
import fr.gouv.vitamui.iam.internal.client.ApplicationInternalRestClient;
import fr.gouv.vitamui.iam.security.client.AbstractInternalClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
@ConfigurationProperties
@EnableConfigurationProperties
public class ApplicationService
extends AbstractInternalClientService {
    private final ApplicationExternalService applicationExternalService;
    private final ApplicationInternalRestClient applicationInternalRestClient;

    public ApplicationService(ExternalSecurityService externalSecurityService, ApplicationExternalService applicationExternalService, ApplicationInternalRestClient applicationInternalRestClient) {
        super(externalSecurityService);
        this.applicationInternalRestClient = applicationInternalRestClient;
        this.applicationExternalService = applicationExternalService;
    }

    public Map<String, Object> getApplications(boolean filterApp) {
        QueryDto query = new QueryDto(QueryOperator.AND);
        query.addCriterion(new Criterion("filterApp", (Object)filterApp, CriterionOperator.EQUALS));
        List applications = this.applicationExternalService.getAll(Optional.of(query.toJson()), Optional.empty());
        HashMap<String, Object> portalConfig = new HashMap<String, Object>();
        portalConfig.put("APPLICATION_CONFIGURATION", applications);
        return portalConfig;
    }

    public ResponseEntity<Boolean> isApplicationExternalIdentifierEnabled(String applicationId) {
        return this.applicationInternalRestClient.isApplicationExternalIdentifierEnabled(this.getInternalHttpContext(), applicationId);
    }

    protected ApplicationInternalRestClient getClient() {
        return this.applicationInternalRestClient;
    }
}

