/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.enums.ContentDispositionType;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookLifeCycleResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.external.server.service.LogbookExternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@Api(tags={"logbooks"})
@RequestMapping(value={"/v1"})
@RestController
@ResponseBody
public class LogbookExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(LogbookExternalController.class);
    private static final String DOWNLOAD_TYPE_DIP = "dip";
    private static final String DOWNLOAD_TYPE_TRANSFER_SIP = "transfersip";
    private static final String DOWNLOAD_TYPE_BATCH_REPORT = "batchreport";
    private static final String DOWNLOAD_TYPE_OBJECT = "object";
    private final LogbookExternalService logbookExternalService;

    @Autowired
    public LogbookExternalController(LogbookExternalService logbookExternalService) {
        this.logbookExternalService = logbookExternalService;
    }

    @ApiOperation(value="Get operation by id")
    @GetMapping(value={"/logbooks/operations/{id}"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public LogbookOperationsResponseDto findOperationByUnitId(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        return this.logbookExternalService.findOperationByUnitId(id);
    }

    @ApiOperation(value="Get logbook unit lifecycle by archive unit id")
    @GetMapping(value={"/logbooks/unitlifecycles/{id}"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public LogbookLifeCycleResponseDto findUnitLifeCyclesByUnitId(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        return this.logbookExternalService.findUnitLifeCyclesByUnitId(id);
    }

    @ApiOperation(value="Get logbook object lifecycle by archive unit id")
    @GetMapping(value={"/logbooks/objectslifecycles/{id}"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public LogbookLifeCycleResponseDto findObjectGroupLifeCyclesByUnitId(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        return this.logbookExternalService.findObjectGroupLifeCyclesByUnitId(id);
    }

    @ApiOperation(value="Get logbook operations by json select")
    @Secured(value={"ROLE_LOGBOOKS"})
    @PostMapping(value={"/logbooks/operations"})
    public LogbookOperationsResponseDto findOperations(@RequestBody JsonNode select, @RequestParam(required=false) Integer vitamTenantIdentifier) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeJson((JsonNode)select);
        SanityChecker.sanitizeCriteria((Object)select);
        LOGGER.debug("Get logbook operations by json select");
        return this.logbookExternalService.findOperations(select, vitamTenantIdentifier);
    }

    @ApiOperation(value="Download the manifest for a given operation")
    @GetMapping(value={"/logbooks/operations/{id}/download/manifest"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> downloadManifest(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the manifest for the Vitam operation : {}", (Object)id);
        ResponseEntity response = this.logbookExternalService.downloadManifest(id);
        return RestUtils.buildFileResponse((ResponseEntity)response, Optional.empty(), Optional.empty());
    }

    @ApiOperation(value="Download the ATR file for a given operation")
    @GetMapping(value={"/logbooks/operations/{id}/download/atr"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> downloadAtr(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the ATR file for the Vitam operation : {}", (Object)id);
        ResponseEntity response = this.logbookExternalService.downloadAtr(id);
        return RestUtils.buildFileResponse((ResponseEntity)response, Optional.empty(), Optional.empty());
    }

    @ApiOperation(value="Download the report file for a given operation")
    @GetMapping(value={"/logbooks/operations/{id}/download/{downloadType}"}, produces={"application/octet-stream"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> downloadReport(@PathVariable String id, @PathVariable String downloadType) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier and the download type are mandatory parameters: ", (String[])new String[]{id, downloadType});
        SanityChecker.checkSecureParameter((String[])new String[]{id, downloadType});
        LOGGER.debug("Download the report file for the Vitam operation : {} with download type : {}", (Object)id, (Object)downloadType);
        ResponseEntity responseResource = (ResponseEntity)this.logbookExternalService.downloadReport(id, downloadType).block();
        String fileName = LogbookExternalController.getDownloadReportFileName((String)id, (String)downloadType);
        return RestUtils.buildFileResponse((ResponseEntity)responseResource, Optional.of(ContentDispositionType.ATTACHMENT), Optional.of(fileName));
    }

    private static String getDownloadReportFileName(String id, String downloadType) {
        Object fileName = id;
        switch (downloadType) {
            case "object": {
                fileName = (String)fileName + ".xml";
                break;
            }
            case "batchreport": {
                fileName = (String)fileName + ".jsonl";
                break;
            }
            case "dip": 
            case "transfersip": {
                fileName = (String)fileName + ".zip";
                break;
            }
            default: {
                fileName = (String)fileName + ".json";
            }
        }
        return fileName;
    }
}

