/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.external.server.service.GroupExternalService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/groups"})
@Api(tags={"groups"}, value="Profiles Groups Management", description="Profiles Groups Management")
public class GroupExternalController
implements CrudController<GroupDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(GroupExternalController.class);
    private final GroupExternalService groupCrudService;

    @Autowired
    public GroupExternalController(GroupExternalService profileGroupCrudService) {
        this.groupCrudService = profileGroupCrudService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_GROUPS"})
    public List<GroupDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("get all group criteria={}, embedded={}", criteria, embedded);
        return this.groupCrudService.getAll(criteria, embedded);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    @Secured(value={"ROLE_GET_GROUPS"})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("check exist by criteria={}", (Object)criteria);
        boolean exist = this.groupCrudService.checkExists(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @GetMapping(value={"/{id}"})
    @Secured(value={"ROLE_GET_GROUPS"})
    public GroupDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        LOGGER.debug("Get group {} embedded={}", (Object)id, embedded);
        return this.groupCrudService.getOne(id, embedded);
    }

    @Secured(value={"ROLE_GET_GROUPS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<GroupDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}, embedded = {}", new Object[]{page, size, orderBy, direction, embedded});
        return this.groupCrudService.getAllPaginated(page, size, criteria, orderBy, direction, embedded);
    }

    @PostMapping
    @Secured(value={"ROLE_CREATE_GROUPS"})
    public GroupDto create(@Valid @RequestBody GroupDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create group {}", (Object)dto);
        return this.groupCrudService.create(dto);
    }

    public GroupDto update(@PathVariable(value="id") String id, @Valid @RequestBody GroupDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_GROUPS"})
    public GroupDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch group {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch group : the DTO id must match the path id");
        return this.groupCrudService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for group with id :{}", (Object)id);
        return this.groupCrudService.findHistoryById(id);
    }

    @GetMapping(value={"/levels"})
    @Secured(value={"ROLE_GET_GROUPS"})
    public List<String> getLevels(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get levels with criteria={}", criteria);
        return this.groupCrudService.getLevels(criteria);
    }

    @GetMapping(value={"/export"})
    @Secured(value={"ROLE_GET_GROUPS"})
    public ResponseEntity<Resource> exportProfileGroups() {
        LOGGER.debug("Export all profile groups to xlsx file");
        return this.groupCrudService.exportProfileGroups();
    }

    @Generated
    public GroupExternalService getGroupCrudService() {
        return this.groupCrudService;
    }
}

