/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.external.server.service.ExternalParametersExternalService;
import io.swagger.annotations.Api;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/externalparameters"})
@Api(tags={"externalParameters"}, value="External Parameters Management")
public class ExternalParametersExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExternalParametersExternalController.class);
    private ExternalParametersExternalService externalParametersExternalService;

    @Autowired
    public ExternalParametersExternalController(ExternalParametersExternalService externalParametersExternalService) {
        this.externalParametersExternalService = externalParametersExternalService;
    }

    @GetMapping(value={"/me"})
    @Secured(value={"ROLE_GET_EXTERNAL_PARAMS"})
    public Map<String, String> getMyExternalParameters() {
        LOGGER.debug("GetMyExternalParameters");
        ExternalParametersDto userParameters = this.externalParametersExternalService.getMyExternalParameters();
        if (userParameters != null && userParameters.getParameters() != null) {
            return userParameters.getParameters().stream().collect(Collectors.toMap(ParameterDto::getKey, ParameterDto::getValue));
        }
        return Collections.emptyMap();
    }

    @Generated
    public ExternalParametersExternalService getExternalParametersExternalService() {
        return this.externalParametersExternalService;
    }

    @Generated
    public void setExternalParametersExternalService(ExternalParametersExternalService externalParametersExternalService) {
        this.externalParametersExternalService = externalParametersExternalService;
    }
}

