/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.server.rest;

import fr.gouv.vitamui.commons.api.domain.AccessContractsDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.external.server.service.AccessContractExternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
@Api(tags={"accesscontracts"}, value="Access contact", description="Access contract Management")
public class AccessContractExternalController {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessContractExternalController.class);
    private final AccessContractExternalService accessContractExternalService;

    @Autowired
    public AccessContractExternalController(AccessContractExternalService accessContractExternalService) {
        this.accessContractExternalService = accessContractExternalService;
    }

    @ApiOperation(value="Get all access contracts")
    @GetMapping(value={"/accesscontracts"})
    @Secured(value={"ROLE_CREATE_EXTERNAL_PARAM_PROFILE"})
    public List<AccessContractsDto> getAll() {
        return this.accessContractExternalService.getAll();
    }

    @ApiOperation(value="Get access contract by ID")
    @GetMapping(path={"/accesscontracts/{identifier:.+}"})
    @Secured(value={"ROLE_GET_ACCESS_CONTRACTS"})
    public AccessContractsDto getById(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get access contract by id {} / {}", (Object)identifier, (Object)URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
        return this.accessContractExternalService.getAccessContractById(URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
    }
}

