/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.service;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.iam.internal.client.ExternalParametersInternalRestClient;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalParametersService {
    public static final String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
    private final ExternalParametersInternalRestClient externalParametersInternalRestClient;
    private final InternalSecurityService securityService;

    @Autowired
    public ExternalParametersService(ExternalParametersInternalRestClient externalParametersInternalRestClient, InternalSecurityService securityService) {
        this.externalParametersInternalRestClient = externalParametersInternalRestClient;
        this.securityService = securityService;
    }

    public String retrieveAccessContractFromExternalParam() {
        ExternalParametersDto myExternalParameter = this.externalParametersInternalRestClient.getMyExternalParameters(this.securityService.getHttpContext());
        if (myExternalParameter == null || CollectionUtils.isEmpty((Collection)myExternalParameter.getParameters())) {
            throw new IllegalArgumentException("No external profile defined for access contract defined");
        }
        ParameterDto parameterAccessContract = myExternalParameter.getParameters().stream().filter(parameter -> PARAM_ACCESS_CONTRACT_NAME.equals(parameter.getKey())).findFirst().orElse(null);
        if (Objects.isNull(parameterAccessContract) || Objects.isNull(parameterAccessContract.getValue())) {
            throw new IllegalArgumentException("No access contract defined");
        }
        return parameterAccessContract.getValue();
    }

    public VitamContext buildVitamContextFromExternalParam() {
        return new VitamContext(this.securityService.getTenantIdentifier()).setAccessContract(this.retrieveAccessContractFromExternalParam()).setApplicationSessionId(this.securityService.getApplicationId());
    }
}

