/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.service;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchAgenciesInternalService;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchInternalService;
import fr.gouv.vitamui.archives.search.common.common.RulesUpdateCommonService;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnit;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitCsv;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.api.dtos.ExportSearchResultParam;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InvalidTypeException;
import fr.gouv.vitamui.commons.api.exception.RequestEntityTooLargeException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.MetadataSearchCriteriaUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class ArchiveSearchUnitExportCsvInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchUnitExportCsvInternalService.class);
    private static final Integer EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS = 10000;
    public static final String FILING_UNIT = "FILING_UNIT";
    public static final String HOLDING_UNIT = "HOLDING_UNIT";
    private static final String INGEST_ARCHIVE_TYPE = "INGEST";
    private final ArchiveSearchAgenciesInternalService archiveSearchAgenciesInternalService;
    private final ArchiveSearchInternalService archiveSearchInternalService;
    private final ObjectMapper objectMapper;

    @Autowired
    public ArchiveSearchUnitExportCsvInternalService(@Lazy ArchiveSearchInternalService archiveSearchInternalService, ArchiveSearchAgenciesInternalService archiveSearchAgenciesInternalService, ObjectMapper objectMapper) {
        this.archiveSearchAgenciesInternalService = archiveSearchAgenciesInternalService;
        this.archiveSearchInternalService = archiveSearchInternalService;
        this.objectMapper = objectMapper;
    }

    public Resource exportToCsvSearchArchiveUnitsByCriteria(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.info("Calling exportToCsvSearchArchiveUnitsByCriteria with query {} ", (Object)searchQuery);
        Locale locale = Locale.FRENCH;
        if (Locale.FRENCH.getLanguage().equals(searchQuery.getLanguage()) || Locale.ENGLISH.getLanguage().equals(searchQuery.getLanguage())) {
            locale = Locale.forLanguageTag(searchQuery.getLanguage());
        }
        ExportSearchResultParam exportSearchResultParam = new ExportSearchResultParam(locale);
        return this.exportToCsvSearchArchiveUnitsByCriteriaAndParams(searchQuery, exportSearchResultParam, vitamContext);
    }

    private Resource exportToCsvSearchArchiveUnitsByCriteriaAndParams(SearchCriteriaDto searchQuery, ExportSearchResultParam exportSearchResultParam, VitamContext vitamContext) throws VitamClientException {
        try {
            this.archiveSearchAgenciesInternalService.mapAgenciesNameToCodes(searchQuery, vitamContext);
            List<ArchiveUnitCsv> unitCsvList = this.exportArchiveUnitsByCriteriaToCsvFile(searchQuery, vitamContext);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8.name());
            String[] headerRecordFr = exportSearchResultParam.getHeaders().toArray(new String[exportSearchResultParam.getHeaders().size()]);
            SimpleDateFormat dateFormat = new SimpleDateFormat(exportSearchResultParam.getPatternDate());
            ICSVWriter csvWriter = new CSVWriterBuilder((Writer)writer).withSeparator(exportSearchResultParam.getSeparator()).withQuoteChar('\"').withEscapeChar('\"').withLineEnd("\n").build();
            csvWriter.writeNext(headerRecordFr);
            unitCsvList.stream().forEach(archiveUnitCsv -> {
                String startDt = null;
                String endDt = null;
                if (archiveUnitCsv.getStartDate() != null) {
                    try {
                        startDt = dateFormat.format(LocalDateUtil.getDate((String)archiveUnitCsv.getStartDate()));
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing starting date {} ", (Object)archiveUnitCsv.getStartDate());
                    }
                }
                if (archiveUnitCsv.getEndDate() != null) {
                    try {
                        endDt = dateFormat.format(LocalDateUtil.getDate((String)archiveUnitCsv.getEndDate()));
                    }
                    catch (ParseException e) {
                        LOGGER.error("Error parsing end date {} ", (Object)archiveUnitCsv.getEndDate());
                    }
                }
                csvWriter.writeNext(new String[]{archiveUnitCsv.getId(), archiveUnitCsv.getArchiveUnitType(), archiveUnitCsv.getOriginatingAgencyName(), (String)exportSearchResultParam.getDescriptionLevelMap().get(archiveUnitCsv.getDescriptionLevel()), archiveUnitCsv.getTitle(), startDt, endDt, archiveUnitCsv.getDescription()});
            });
            csvWriter.close();
            ((Writer)writer).close();
            return new ByteArrayResource(outputStream.toByteArray());
        }
        catch (IOException ex) {
            throw new BadRequestException("Unable to export csv file ", (Throwable)ex);
        }
    }

    private List<ArchiveUnitCsv> exportArchiveUnitsByCriteriaToCsvFile(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.info("Calling exporting  export ArchiveUnits to CSV with criteria {}", (Object)searchQuery);
            this.checkSizeLimit(vitamContext, searchQuery);
            searchQuery.setPageNumber(Integer.valueOf(0));
            searchQuery.setSize(EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS);
            JsonNode archiveUnitsResult = this.archiveSearchInternalService.searchArchiveUnits(this.archiveSearchInternalService.mapRequestToDslQuery(searchQuery), vitamContext);
            VitamUISearchResponseDto archivesResponse = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)archiveUnitsResult, VitamUISearchResponseDto.class);
            LOGGER.info("archivesResponse found {} ", (Object)archivesResponse.getResults().size());
            Set<String> originesAgenciesCodes = archivesResponse.getResults().stream().map(ResultsDto::getOriginatingAgency).filter(Objects::nonNull).collect(Collectors.toSet());
            List<AgencyModelDto> originAgenciesFound = this.archiveSearchAgenciesInternalService.findOriginAgenciesByCodes(vitamContext, originesAgenciesCodes);
            Map<String, AgencyModelDto> agenciesMapByIdentifier = originAgenciesFound.stream().collect(Collectors.toMap(AgencyModelDto::getIdentifier, agency -> agency));
            return archivesResponse.getResults().stream().map(archiveUnit -> RulesUpdateCommonService.fillOriginatingAgencyName((ResultsDto)archiveUnit, (Map)agenciesMapByIdentifier)).map(archiveUnit -> this.cleanAndMapArchiveUnitResult((ArchiveUnit)archiveUnit, searchQuery.getLanguage())).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Can't parse criteria as Vitam query {} : ", (Throwable)e);
            throw new BadRequestException("Can't parse criteria as Vitam query", (Throwable)e);
        }
    }

    private void checkSizeLimit(VitamContext vitamContext, SearchCriteriaDto searchQuery) throws VitamClientException, IOException {
        SearchCriteriaDto searchQueryCounting = new SearchCriteriaDto();
        searchQueryCounting.setCriteriaList(searchQuery.getCriteriaList());
        JsonNode archiveUnitsResult = this.archiveSearchInternalService.searchArchiveUnits(this.archiveSearchInternalService.mapRequestToDslQuery(searchQueryCounting), vitamContext);
        VitamUISearchResponseDto archivesOriginResponse = (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)archiveUnitsResult, VitamUISearchResponseDto.class);
        Integer nbResults = archivesOriginResponse.getHits().getTotal();
        if (nbResults >= EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS) {
            LOGGER.error("The archives units result found is greater than allowed {} ", (Object)EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS);
            throw new RequestEntityTooLargeException("The archives units result found is greater than allowed:  " + EXPORT_ARCHIVE_UNITS_MAX_ELEMENTS);
        }
    }

    private ArchiveUnitCsv cleanAndMapArchiveUnitResult(ArchiveUnit archiveUnit, String language) {
        if (archiveUnit == null) {
            return null;
        }
        ArchiveUnitCsv archiveUnitCsv = new ArchiveUnitCsv();
        BeanUtils.copyProperties((Object)archiveUnit, (Object)archiveUnitCsv);
        archiveUnitCsv.setDescription(MetadataSearchCriteriaUtils.cleanString((String)this.getArchiveUnitDescription(archiveUnit)));
        archiveUnitCsv.setDescriptionLevel(archiveUnit.getDescriptionLevel() != null ? MetadataSearchCriteriaUtils.cleanString((String)archiveUnit.getDescriptionLevel()) : null);
        archiveUnitCsv.setArchiveUnitType(this.getArchiveUnitType(archiveUnit, language));
        archiveUnitCsv.setTitle(MetadataSearchCriteriaUtils.cleanString((String)this.getArchiveUnitTitle(archiveUnit)));
        archiveUnitCsv.setOriginatingAgencyName(archiveUnit.getOriginatingAgencyName() != null ? MetadataSearchCriteriaUtils.cleanString((String)archiveUnit.getOriginatingAgencyName()) : null);
        return archiveUnitCsv;
    }

    private String getArchiveUnitTitle(ArchiveUnit archiveUnit) {
        return this.getArchiveUnitI18nAttribute(archiveUnit, ResultsDto::getTitle, ResultsDto::getTitle_);
    }

    private String getArchiveUnitDescription(ArchiveUnit archiveUnit) {
        return this.getArchiveUnitI18nAttribute(archiveUnit, ResultsDto::getDescription, ResultsDto::getDescription_);
    }

    private String getArchiveUnitI18nAttribute(ArchiveUnit archiveUnit, Function<ArchiveUnit, String> attributeExtractor, Function<ArchiveUnit, Map<String, String>> i18nAttributeExtractor) {
        if (archiveUnit == null) {
            return null;
        }
        String attribute = attributeExtractor.apply(archiveUnit);
        if (StringUtils.isNotBlank((String)attribute)) {
            return attribute;
        }
        Map<String, String> attribute_ = i18nAttributeExtractor.apply(archiveUnit);
        if (attribute_ == null) {
            return null;
        }
        return Stream.of("fr", "en").map(lang -> attribute_.entrySet().stream().filter(e -> lang.equalsIgnoreCase((String)e.getKey())).findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst().map(Map.Entry::getValue).or(() -> attribute_.values().stream().findFirst()).orElse(null);
    }

    private String getArchiveUnitType(ArchiveUnit archiveUnit, String language) {
        String archiveUnitType = null;
        if (archiveUnit != null && !StringUtils.isEmpty((String)archiveUnit.getUnitType())) {
            switch (archiveUnit.getUnitType()) {
                case "FILING_UNIT": {
                    archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Plan de classement" : "Filling scheme";
                    break;
                }
                case "HOLDING_UNIT": {
                    archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Arbre de positionnement" : "Holding scheme";
                    break;
                }
                case "INGEST": {
                    if (StringUtils.isEmpty((String)archiveUnit.getUnitObject())) {
                        archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Archive sans objet" : "Archive without object";
                        break;
                    }
                    archiveUnitType = language.equals(Locale.FRENCH.getLanguage()) ? "Archive avec objet" : "Archive with object";
                    break;
                }
                default: {
                    throw new InvalidTypeException("Description Level Type is Unknown !");
                }
            }
        }
        return archiveUnitType;
    }
}

