/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.massupdate.MassUpdateUnitRuleRequest;
import fr.gouv.vitam.common.model.massupdate.RuleActions;
import fr.gouv.vitamui.archive.internal.server.rulesupdate.converter.RuleOperationsConverter;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchInternalService;
import fr.gouv.vitamui.archives.search.common.common.RulesUpdateCommonService;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.commons.api.exception.ForbiddenException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.UnitService;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractService;
import fr.gouv.vitamui.iam.common.dto.AccessContractsResponseDto;
import fr.gouv.vitamui.iam.common.dto.AccessContractsVitamDto;
import java.util.Collection;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ArchiveSearchMgtRulesInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchMgtRulesInternalService.class);
    private final ObjectMapper objectMapper;
    private final ArchiveSearchInternalService archiveSearchInternalService;
    private final RuleOperationsConverter ruleOperationsConverter;
    private final AccessContractService accessContractService;
    private final UnitService unitService;

    @Autowired
    public ArchiveSearchMgtRulesInternalService(@Lazy ArchiveSearchInternalService archiveSearchInternalService, RuleOperationsConverter ruleOperationsConverter, AccessContractService accessContractService, UnitService unitService, ObjectMapper objectMapper) {
        this.archiveSearchInternalService = archiveSearchInternalService;
        this.objectMapper = objectMapper;
        this.ruleOperationsConverter = ruleOperationsConverter;
        this.accessContractService = accessContractService;
        this.unitService = unitService;
    }

    public String updateArchiveUnitsRules(RuleSearchCriteriaDto ruleSearchCriteriaDto, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Add Rules to ArchiveUnits using query : {} and DSL actions : {}", (Object)ruleSearchCriteriaDto.getSearchCriteriaDto().toString(), (Object)ruleSearchCriteriaDto.getRuleActions());
        boolean hasAccessContractWritePermission = this.checkAccessContractWritePermission(vitamContext);
        if (!hasAccessContractWritePermission) {
            LOGGER.error("the access contract : {} ,using to update unit rules has no writing permission to update units", (Object)vitamContext.getAccessContract());
            throw new ForbiddenException("the access contract using to update unit rules has no writing permission to update units");
        }
        RuleActions ruleActions = this.ruleOperationsConverter.convertToVitamRuleActions(ruleSearchCriteriaDto.getRuleActions());
        MassUpdateUnitRuleRequest massUpdateUnitRuleRequest = new MassUpdateUnitRuleRequest();
        JsonNode dslQuery = this.archiveSearchInternalService.mapRequestToDslQuery(ruleSearchCriteriaDto.getSearchCriteriaDto());
        ObjectNode dslRequest = (ObjectNode)dslQuery;
        RulesUpdateCommonService.deleteAttributesFromObjectNode((ObjectNode)dslRequest, (String[])new String[]{"$projection", "$filter", "$facets"});
        RulesUpdateCommonService.setMassUpdateUnitRuleRequest((MassUpdateUnitRuleRequest)massUpdateUnitRuleRequest, (RuleActions)ruleActions, (ObjectNode)dslRequest);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JsonNode updateQuery = (JsonNode)this.objectMapper.convertValue((Object)massUpdateUnitRuleRequest, JsonNode.class);
        LOGGER.debug("Add Rules to UA final updateQuery : {}", (Object)updateQuery);
        return this.massUpdateUnitsRules(vitamContext, updateQuery);
    }

    public String massUpdateUnitsRules(VitamContext vitamContext, JsonNode updateQuery) throws VitamClientException {
        JsonNode response = this.unitService.massUpdateUnitsRules(vitamContext, updateQuery).toJsonNode();
        return response.findValue("itemId").textValue();
    }

    private boolean checkAccessContractWritePermission(VitamContext vitamContext) {
        AccessContractsResponseDto accessContractResponseDto;
        LOGGER.debug("Check access contract writing permissions : {}", (Object)vitamContext.getAccessContract());
        try {
            RequestResponse response = this.accessContractService.findAccessContractById(vitamContext, vitamContext.getAccessContract());
            accessContractResponseDto = (AccessContractsResponseDto)this.objectMapper.treeToValue((TreeNode)response.toJsonNode(), AccessContractsResponseDto.class);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Error while parsing Vitam response", e);
        }
        if (Objects.nonNull(accessContractResponseDto) && !CollectionUtils.isEmpty((Collection)accessContractResponseDto.getResults())) {
            return ((AccessContractsVitamDto)accessContractResponseDto.getResults().get(0)).getWritingPermission();
        }
        LOGGER.error("the access contract {} using to update unit rules is not found in vitam", (Object)vitamContext.getAccessContract());
        throw new ForbiddenException("the access contract is not found, update unit rules will fail.");
    }
}

