/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.archive.internal.server.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.configuration.BuilderToken;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitamui.archive.internal.server.service.ArchiveSearchInternalService;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.EliminationService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ArchiveSearchEliminationInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveSearchEliminationInternalService.class);
    private final EliminationService eliminationService;
    private final ArchiveSearchInternalService archiveSearchInternalService;
    private final ObjectMapper objectMapper;

    @Autowired
    public ArchiveSearchEliminationInternalService(@Lazy ArchiveSearchInternalService archiveSearchInternalService, EliminationService eliminationService, ObjectMapper objectMapper) {
        this.eliminationService = eliminationService;
        this.archiveSearchInternalService = archiveSearchInternalService;
        this.objectMapper = objectMapper;
    }

    public JsonNode startEliminationAction(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Elimination action by criteria {} ", (Object)searchQuery.toString());
        JsonNode dslQuery = this.archiveSearchInternalService.prepareDslQuery(searchQuery, vitamContext);
        EliminationRequestBody eliminationRequestBody = null;
        eliminationRequestBody = this.getEliminationRequestBody(dslQuery, searchQuery.getThreshold());
        LOGGER.debug("Elimination action final query {} ", (Object)JsonHandler.prettyPrint((Object)eliminationRequestBody.getDslRequest()));
        RequestResponse jsonNodeRequestResponse = this.eliminationService.startEliminationAction(vitamContext, eliminationRequestBody);
        return jsonNodeRequestResponse.toJsonNode();
    }

    public EliminationRequestBody getEliminationRequestBody(JsonNode updateSet, Long threshold) {
        ObjectNode query = JsonHandler.createObjectNode();
        query.set(BuilderToken.GLOBAL.ROOTS.exactToken(), updateSet.get(BuilderToken.GLOBAL.ROOTS.exactToken()));
        query.set(BuilderToken.GLOBAL.QUERY.exactToken(), updateSet.get(BuilderToken.GLOBAL.QUERY.exactToken()));
        if (threshold != null) {
            query.set(BuilderToken.GLOBAL.THRESOLD.exactToken(), (JsonNode)this.objectMapper.convertValue((Object)threshold, JsonNode.class));
        }
        EliminationRequestBody requestBody = new EliminationRequestBody();
        requestBody.setDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        requestBody.setDslRequest((JsonNode)query);
        return requestBody;
    }

    public JsonNode startEliminationAnalysis(SearchCriteriaDto searchQuery, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Elimination analysis by criteria {} ", (Object)searchQuery.toString());
        JsonNode dslQuery = this.archiveSearchInternalService.prepareDslQuery(searchQuery, vitamContext);
        EliminationRequestBody eliminationRequestBody = this.getEliminationRequestBody(dslQuery, searchQuery.getThreshold());
        LOGGER.debug("Elimination analysis final query {} ", (Object)JsonHandler.prettyPrint((Object)eliminationRequestBody.getDslRequest()));
        RequestResponse jsonNodeRequestResponse = this.eliminationService.startEliminationAnalysis(vitamContext, eliminationRequestBody);
        return jsonNodeRequestResponse.toJsonNode();
    }
}

