/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileDto;
import fr.gouv.vitamui.referential.internal.client.SecurityProfileInternalRestClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecurityProfileExternalService
extends AbstractResourceClientService<SecurityProfileDto, SecurityProfileDto> {
    private SecurityProfileInternalRestClient securityProfileInternalRestClient;

    @Autowired
    public SecurityProfileExternalService(ExternalSecurityService externalSecurityService, SecurityProfileInternalRestClient securityProfileInternalRestClient) {
        super(externalSecurityService);
        this.securityProfileInternalRestClient = securityProfileInternalRestClient;
    }

    public List<SecurityProfileDto> getAll(Optional<String> criteria) {
        return this.securityProfileInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<SecurityProfileDto, InternalHttpContext> getClient() {
        return this.securityProfileInternalRestClient;
    }

    public PaginatedValuesDto<SecurityProfileDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        return this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
    }

    public SecurityProfileDto getOne(String id) {
        return (SecurityProfileDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public SecurityProfileDto patch(Map<String, Object> partialDto) {
        return (SecurityProfileDto)super.patch(partialDto);
    }

    public SecurityProfileDto create(SecurityProfileDto accessContractDto) {
        return (SecurityProfileDto)this.securityProfileInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)accessContractDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(SecurityProfileDto accessContractDto) {
        return this.securityProfileInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    public void delete(String id) {
        this.securityProfileInternalRestClient.delete((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    @Generated
    public SecurityProfileInternalRestClient getSecurityProfileInternalRestClient() {
        return this.securityProfileInternalRestClient;
    }

    @Generated
    public void setSecurityProfileInternalRestClient(SecurityProfileInternalRestClient securityProfileInternalRestClient) {
        this.securityProfileInternalRestClient = securityProfileInternalRestClient;
    }
}

