/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.RuleDto;
import fr.gouv.vitamui.referential.internal.client.RuleInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.RuleInternalWebClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RuleExternalService
extends AbstractResourceClientService<RuleDto, RuleDto> {
    private RuleInternalRestClient ruleInternalRestClient;
    private RuleInternalWebClient ruleInternalWebClient;

    @Autowired
    public RuleExternalService(ExternalSecurityService externalSecurityService, RuleInternalRestClient ruleInternalRestClient, RuleInternalWebClient ruleInternalWebClient) {
        super(externalSecurityService);
        this.ruleInternalRestClient = ruleInternalRestClient;
        this.ruleInternalWebClient = ruleInternalWebClient;
    }

    public List<RuleDto> getAll(Optional<String> criteria) {
        return this.ruleInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<RuleDto, InternalHttpContext> getClient() {
        return this.ruleInternalRestClient;
    }

    public PaginatedValuesDto<RuleDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        return this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
    }

    public RuleDto getOne(String id) {
        return (RuleDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public boolean patchRule(String id, Map<String, Object> partialDto) {
        return this.ruleInternalRestClient.patchRule(this.getInternalHttpContext(), id, partialDto);
    }

    public boolean createRule(RuleDto ruleDto) {
        return this.ruleInternalRestClient.createRule(this.getInternalHttpContext(), ruleDto);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(RuleDto accessContractDto) {
        return this.ruleInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    public boolean deleteRule(String id) {
        return this.ruleInternalRestClient.deleteRule(this.getInternalHttpContext(), id);
    }

    public ResponseEntity<Resource> export() {
        return this.ruleInternalRestClient.export(this.getInternalHttpContext());
    }

    public JsonNode importRules(String fileName, MultipartFile file) {
        return this.ruleInternalWebClient.importRules(this.getInternalHttpContext(), fileName, file);
    }

    @Generated
    public RuleInternalRestClient getRuleInternalRestClient() {
        return this.ruleInternalRestClient;
    }

    @Generated
    public RuleInternalWebClient getRuleInternalWebClient() {
        return this.ruleInternalWebClient;
    }

    @Generated
    public void setRuleInternalRestClient(RuleInternalRestClient ruleInternalRestClient) {
        this.ruleInternalRestClient = ruleInternalRestClient;
    }

    @Generated
    public void setRuleInternalWebClient(RuleInternalWebClient ruleInternalWebClient) {
        this.ruleInternalWebClient = ruleInternalWebClient;
    }
}

