/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.ProfileDto;
import fr.gouv.vitamui.referential.internal.client.ProfileInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.ProfileInternalWebClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProfileExternalService
extends AbstractResourceClientService<ProfileDto, ProfileDto> {
    @Autowired
    private ProfileInternalRestClient profileInternalRestClient;
    private ProfileInternalWebClient profileInternalWebClient;

    @Autowired
    public ProfileExternalService(@Autowired ExternalSecurityService externalSecurityService, ProfileInternalRestClient profileInternalRestClient, ProfileInternalWebClient profileInternalWebClient) {
        super(externalSecurityService);
        this.profileInternalRestClient = profileInternalRestClient;
        this.profileInternalWebClient = profileInternalWebClient;
    }

    public List<ProfileDto> getAll(Optional<String> criteria) {
        return this.profileInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<ProfileDto, InternalHttpContext> getClient() {
        return this.profileInternalRestClient;
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public PaginatedValuesDto<ProfileDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(arg_0 -> ((ProfileExternalService)this).converterToExternalDto(arg_0)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public ProfileDto getOne(String id) {
        return (ProfileDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ProfileDto patch(Map<String, Object> partialDto) {
        return (ProfileDto)super.patch(partialDto);
    }

    public ProfileDto create(ProfileDto accessContractDto) {
        return (ProfileDto)this.profileInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)accessContractDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    public ResponseEntity<JsonNode> updateProfile(ProfileDto dto) {
        return this.profileInternalRestClient.updateProfile(this.getInternalHttpContext(), dto);
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(ProfileDto accessContractDto) {
        return this.profileInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    public void delete(String id) {
        this.profileInternalRestClient.delete((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ResponseEntity<Resource> download(String id) {
        return this.profileInternalRestClient.download(this.getInternalHttpContext(), id);
    }

    public ResponseEntity<JsonNode> importProfiles(String fileName, MultipartFile file) {
        return this.profileInternalWebClient.importProfiles(this.getInternalHttpContext(), fileName, file);
    }

    public ResponseEntity<JsonNode> updateProfileFile(String id, MultipartFile profileFile) throws IOException {
        return this.profileInternalRestClient.updateProfileFile(this.getInternalHttpContext(), id, profileFile);
    }

    @Generated
    public ProfileInternalRestClient getProfileInternalRestClient() {
        return this.profileInternalRestClient;
    }

    @Generated
    public ProfileInternalWebClient getProfileInternalWebClient() {
        return this.profileInternalWebClient;
    }

    @Generated
    public void setProfileInternalRestClient(ProfileInternalRestClient profileInternalRestClient) {
        this.profileInternalRestClient = profileInternalRestClient;
    }

    @Generated
    public void setProfileInternalWebClient(ProfileInternalWebClient profileInternalWebClient) {
        this.profileInternalWebClient = profileInternalWebClient;
    }
}

