/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import fr.gouv.vitamui.referential.internal.client.OntologyInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.OntologyInternalWebClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class OntologyExternalService
extends AbstractResourceClientService<OntologyDto, OntologyDto> {
    private OntologyInternalRestClient ontologyInternalRestClient;
    private OntologyInternalWebClient ontologyInternalWebClient;

    @Autowired
    public OntologyExternalService(ExternalSecurityService externalSecurityService, OntologyInternalRestClient ontologyInternalRestClient, OntologyInternalWebClient ontologyInternalWebClient) {
        super(externalSecurityService);
        this.ontologyInternalRestClient = ontologyInternalRestClient;
        this.ontologyInternalWebClient = ontologyInternalWebClient;
    }

    public List<OntologyDto> getAll(Optional<String> criteria) {
        return this.ontologyInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    public OntologyDto getOne(String id) {
        return (OntologyDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    protected BasePaginatingAndSortingRestClient<OntologyDto, InternalHttpContext> getClient() {
        return this.ontologyInternalRestClient;
    }

    public PaginatedValuesDto<OntologyDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(element -> (OntologyDto)this.converterToExternalDto((IdDto)element)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public OntologyDto create(OntologyDto accessContractDto) {
        return (OntologyDto)this.ontologyInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)accessContractDto);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public OntologyDto patch(Map<String, Object> partialDto) {
        return (OntologyDto)super.patch(partialDto);
    }

    public void delete(String id) {
        this.ontologyInternalRestClient.delete((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public boolean check(OntologyDto ontologyDto) {
        return this.ontologyInternalRestClient.check(this.getInternalHttpContext(), ontologyDto);
    }

    public JsonNode importOntologies(String fileName, MultipartFile file) {
        return this.ontologyInternalWebClient.importOntologies(this.getInternalHttpContext(), fileName, file);
    }

    public List<VitamUiOntologyDto> getInternalOntologyList() {
        return this.ontologyInternalRestClient.getInternalOntologyList(this.getInternalHttpContext());
    }

    @Generated
    public OntologyInternalRestClient getOntologyInternalRestClient() {
        return this.ontologyInternalRestClient;
    }

    @Generated
    public OntologyInternalWebClient getOntologyInternalWebClient() {
        return this.ontologyInternalWebClient;
    }

    @Generated
    public void setOntologyInternalRestClient(OntologyInternalRestClient ontologyInternalRestClient) {
        this.ontologyInternalRestClient = ontologyInternalRestClient;
    }

    @Generated
    public void setOntologyInternalWebClient(OntologyInternalWebClient ontologyInternalWebClient) {
        this.ontologyInternalWebClient = ontologyInternalWebClient;
    }
}

