/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.IngestContractDto;
import fr.gouv.vitamui.referential.internal.client.IngestContractInternalRestClient;
import fr.gouv.vitamui.referential.internal.client.IngestContractInternalWebClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IngestContractExternalService
extends AbstractResourceClientService<IngestContractDto, IngestContractDto> {
    private IngestContractInternalRestClient ingestContractInternalRestClient;
    private IngestContractInternalWebClient ingestContractInternalWebClient;

    @Autowired
    public IngestContractExternalService(ExternalSecurityService externalSecurityService, IngestContractInternalRestClient ingestContractInternalRestClient, IngestContractInternalWebClient ingestContractInternalWebClient) {
        super(externalSecurityService);
        this.ingestContractInternalRestClient = ingestContractInternalRestClient;
        this.ingestContractInternalWebClient = ingestContractInternalWebClient;
    }

    public List<IngestContractDto> getAll(Optional<String> criteria) {
        return this.ingestContractInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    public IngestContractDto getOne(String id) {
        return (IngestContractDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public IngestContractDto patch(Map<String, Object> partialDto) {
        return (IngestContractDto)super.patch(partialDto);
    }

    public IngestContractDto create(IngestContractDto ingestContractDto) {
        return (IngestContractDto)this.ingestContractInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)ingestContractDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name");
    }

    protected BasePaginatingAndSortingRestClient<IngestContractDto, InternalHttpContext> getClient() {
        return this.ingestContractInternalRestClient;
    }

    public PaginatedValuesDto<IngestContractDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        PaginatedValuesDto result = this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
        return new PaginatedValuesDto((Collection)result.getValues().stream().map(element -> (IngestContractDto)this.converterToExternalDto((IdDto)element)).collect(Collectors.toList()), result.getPageNum(), result.getPageSize(), result.isHasMore());
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(IngestContractDto ingestContractDto) {
        return this.ingestContractInternalRestClient.check(this.getInternalHttpContext(), ingestContractDto);
    }

    public ResponseEntity<Void> importIngestContracts(MultipartFile file) {
        return this.ingestContractInternalWebClient.importIngestContracts(this.getInternalHttpContext(), file);
    }

    public ResponseEntity<Resource> exportIngestContracts() {
        return this.ingestContractInternalRestClient.exportIngestContracts(this.getInternalHttpContext());
    }

    @Generated
    public IngestContractInternalRestClient getIngestContractInternalRestClient() {
        return this.ingestContractInternalRestClient;
    }

    @Generated
    public IngestContractInternalWebClient getIngestContractInternalWebClient() {
        return this.ingestContractInternalWebClient;
    }

    @Generated
    public void setIngestContractInternalRestClient(IngestContractInternalRestClient ingestContractInternalRestClient) {
        this.ingestContractInternalRestClient = ingestContractInternalRestClient;
    }

    @Generated
    public void setIngestContractInternalWebClient(IngestContractInternalWebClient ingestContractInternalWebClient) {
        this.ingestContractInternalWebClient = ingestContractInternalWebClient;
    }
}

