/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.internal.client.ContextInternalRestClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContextExternalService
extends AbstractResourceClientService<ContextDto, ContextDto> {
    private ContextInternalRestClient contextInternalRestClient;

    @Autowired
    public ContextExternalService(ExternalSecurityService externalSecurityService, ContextInternalRestClient contextInternalRestClient) {
        super(externalSecurityService);
        this.contextInternalRestClient = contextInternalRestClient;
    }

    public List<ContextDto> getAll(Optional<String> criteria) {
        return this.contextInternalRestClient.getAll((AbstractHttpContext)this.getInternalHttpContext(), criteria);
    }

    protected BasePaginatingAndSortingRestClient<ContextDto, InternalHttpContext> getClient() {
        return this.contextInternalRestClient;
    }

    public PaginatedValuesDto<ContextDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        return this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
    }

    public ContextDto getOne(String id) {
        return (ContextDto)this.getClient().getOne((AbstractHttpContext)this.getInternalHttpContext(), id);
    }

    public ContextDto patch(ContextDto partialDto) {
        return (ContextDto)super.patchWithDto((IdDto)partialDto);
    }

    public ContextDto create(ContextDto accessContractDto) {
        return (ContextDto)this.contextInternalRestClient.create((AbstractHttpContext)this.getInternalHttpContext(), (IdDto)accessContractDto);
    }

    public boolean checkExists(String criteria) {
        return super.checkExists(criteria);
    }

    protected Collection<String> getAllowedKeys() {
        return Arrays.asList("name", "identifier");
    }

    public LogbookOperationsResponseDto findHistoryById(String id) {
        JsonNode body = this.getClient().findHistoryById((AbstractHttpContext)this.getInternalHttpContext(), id);
        try {
            return (LogbookOperationsResponseDto)JsonUtils.treeToValue((JsonNode)body, LogbookOperationsResponseDto.class, (boolean)false);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("Error while parsing Vitam response", (Throwable)e);
        }
    }

    public boolean check(ContextDto accessContractDto) {
        return this.contextInternalRestClient.check(this.getInternalHttpContext(), accessContractDto);
    }

    @Generated
    public ContextInternalRestClient getContextInternalRestClient() {
        return this.contextInternalRestClient;
    }

    @Generated
    public void setContextInternalRestClient(ContextInternalRestClient contextInternalRestClient) {
        this.contextInternalRestClient = contextInternalRestClient;
    }
}

