/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.service;

import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.AccessionRegisterSearchDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.AccessionRegisterDetailDto;
import fr.gouv.vitamui.referential.internal.client.AccessionRegisterDetailInternalRestClient;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class AccessionRegisterDetailExternalService
extends AbstractResourceClientService<AccessionRegisterDetailDto, AccessionRegisterDetailDto> {
    private final AccessionRegisterDetailInternalRestClient accessionRegisterDetailInternalRestClient;

    @Autowired
    public AccessionRegisterDetailExternalService(ExternalSecurityService externalSecurityService, AccessionRegisterDetailInternalRestClient accessionRegisterDetailInternalRestClient) {
        super(externalSecurityService);
        this.accessionRegisterDetailInternalRestClient = accessionRegisterDetailInternalRestClient;
    }

    public PaginatedValuesDto<AccessionRegisterDetailDto> getAllPaginated(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        ParameterChecker.checkPagination((Integer)size, (Integer)page);
        return this.getClient().getAllPaginated((AbstractHttpContext)this.getInternalHttpContext(), page, size, criteria, orderBy, direction);
    }

    protected BasePaginatingAndSortingRestClient<AccessionRegisterDetailDto, InternalHttpContext> getClient() {
        return this.accessionRegisterDetailInternalRestClient;
    }

    public Resource exportCsvArchiveUnitsByCriteria(AccessionRegisterSearchDto query) {
        return this.accessionRegisterDetailInternalRestClient.exportAccessionRegisterCsv(query, this.getInternalHttpContext());
    }
}

