/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.SchemaDto;
import fr.gouv.vitamui.referential.common.exception.NoCollectionException;
import fr.gouv.vitamui.referential.common.model.Collection;
import fr.gouv.vitamui.referential.external.server.service.SchemaService;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/schemas"})
public class SchemaController {
    private final SchemaService schemaService;
    private final ExternalSecurityService externalSecurityService;

    @Autowired
    public SchemaController(SchemaService schemaService, ExternalSecurityService externalSecurityService) {
        this.schemaService = schemaService;
        this.externalSecurityService = externalSecurityService;
    }

    @GetMapping
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_GET_SCHEMAS"})
    public ResponseEntity<List<SchemaDto>> getSchemas(@RequestParam Set<Collection> collections) throws NoCollectionException, URISyntaxException {
        if (CollectionUtils.isEmpty(collections)) {
            throw new NoCollectionException();
        }
        return ResponseEntity.ok(this.schemaService.getSchemas(InternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)this.externalSecurityService.getHttpContext()), collections));
    }
}

