/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.external.server.rest;

import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ManagementContractDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.external.server.service.ManagementContractExternalService;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/management-contract"})
public class ManagementContractExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ManagementContractExternalController.class);
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private final ManagementContractExternalService managementContractExternalService;

    @Autowired
    public ManagementContractExternalController(ManagementContractExternalService managementContractExternalService) {
        this.managementContractExternalService = managementContractExternalService;
    }

    @GetMapping
    @Secured(value={"ROLE_GET_MANAGEMENT_CONTRACT"})
    public Collection<ManagementContractDto> getAll(Optional<String> criteria) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("get all management contracts criteria={}", criteria);
        return this.managementContractExternalService.getAll(criteria);
    }

    @GetMapping(params={"page", "size"})
    @Secured(value={"ROLE_GET_MANAGEMENT_CONTRACT"})
    public PaginatedValuesDto<ManagementContractDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws PreconditionFailedException {
        orderBy.ifPresent(xva$0 -> SanityChecker.checkSecureParameter((String[])new String[]{xva$0}));
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.managementContractExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @GetMapping(path={"/{identifier:.+}"})
    @Secured(value={"ROLE_GET_MANAGEMENT_CONTRACT"})
    public ManagementContractDto getOne(@PathVariable(value="identifier") String identifier) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{identifier});
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("get managementContract  by identifier = {}", (Object)identifier);
        return this.managementContractExternalService.getOne(identifier);
    }

    @PostMapping(value={"/check"})
    @Secured(value={"ROLE_GET_MANAGEMENT_CONTRACT"})
    public ResponseEntity<Void> check(@RequestBody ManagementContractDto managementContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        SanityChecker.sanitizeCriteria((Object)managementContractDto);
        LOGGER.debug("check exist managementContract = {}", (Object)managementContractDto);
        boolean exist = this.managementContractExternalService.check(managementContractDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping
    @Secured(value={"ROLE_CREATE_MANAGEMENT_CONTRACT"})
    public ManagementContractDto create(@Valid @RequestBody ManagementContractDto managementContractDto) throws PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)managementContractDto);
        LOGGER.debug("Create new management contract {}", (Object)managementContractDto);
        return this.managementContractExternalService.create(managementContractDto);
    }

    @PatchMapping(value={"/{id}"})
    @Secured(value={"ROLE_UPDATE_MANAGEMENT_CONTRACT"})
    public ManagementContractDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        return this.managementContractExternalService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    @Secured(value={"ROLE_GET_MANAGEMENT_CONTRACT"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable(value="id") String id) throws PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for ManagementContract with id :{}", (Object)id);
        return this.managementContractExternalService.findHistoryById(id);
    }

    @Generated
    public ManagementContractExternalService getManagementContractExternalService() {
        return this.managementContractExternalService;
    }
}

