/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.util;

import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.dto.factory.RngTag;
import fr.gouv.vitamui.pastis.common.dto.factory.RngTagFactory;
import fr.gouv.vitamui.pastis.common.util.PastisCustomCharacterEscapeHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PastisMarshaller {
    public static final String CHAR_ESCAPE_HANDLER = "com.sun.xml.bind.marshaller.CharacterEscapeHandler";
    public static final String MARSHALLER_FORMAT = "jaxb.formatted.output";
    private static final Logger LOGGER = LoggerFactory.getLogger(PastisMarshaller.class);

    public String getMarshalledObject(ElementProperties mappedJson) throws IOException, JAXBException {
        RngTagFactory tagFactory = new RngTagFactory();
        RngTag rngTree = tagFactory.createTag(mappedJson, null, 0);
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{RngTag.class});
        Marshaller marshallerObj = contextObj.createMarshaller();
        marshallerObj.setProperty(MARSHALLER_FORMAT, (Object)true);
        marshallerObj.setProperty(CHAR_ESCAPE_HANDLER, (Object)new PastisCustomCharacterEscapeHandler());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8);
        marshallerObj.marshal((Object)rngTree, (Writer)writer);
        String response = new String(os.toByteArray(), StandardCharsets.UTF_8);
        ((Writer)writer).close();
        String status = !response.isEmpty() ? "Json marshalled successfully" : "Failed to marshall json object";
        LOGGER.debug(status);
        return response;
    }
}

