/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.apache.xerces.util.XMLCatalogResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ManifestValidator {
    public static final String RNG_FACTORY = "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory";
    public static final String RNG_PROPERTY_KEY = "javax.xml.validation.SchemaFactory:http://relaxng.org/ns/structure/1.0";
    public static final String HTTP_WWW_W3_ORG_XML_XML_SCHEMA_V1_1 = "http://www.w3.org/XML/XMLSchema/v1.1";
    public static final String CATALOG_FILENAME = "xsd_validation/catalog.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManifestValidator.class);
    private static final String RNG_SUFFIX = ".rng";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFileRNG(InputStream manifestFile, File rngFile) {
        try {
            if (rngFile.length() > 0L) {
                Schema schema = this.getSchema(rngFile);
                Validator validator = schema.newValidator();
                validator.validate(new StreamSource(manifestFile));
                boolean bl = true;
                return bl;
            }
            LOGGER.error("Le fichier RNG est vide");
            boolean schema = false;
            return schema;
        }
        catch (IOException | SAXException e) {
            LOGGER.error("Erreur validation du manifest", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Closeable)manifestFile);
        }
    }

    private Schema getSchema(File file) throws SAXException {
        SchemaFactory factory;
        if (file.getName().endsWith(RNG_SUFFIX)) {
            System.setProperty(RNG_PROPERTY_KEY, RNG_FACTORY);
            factory = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
        } else {
            factory = SchemaFactory.newInstance(HTTP_WWW_W3_ORG_XML_XML_SCHEMA_V1_1);
        }
        URL catalogUrl = ManifestValidator.class.getClassLoader().getResource(CATALOG_FILENAME);
        factory.setResourceResolver((LSResourceResolver)new XMLCatalogResolver(new String[]{catalogUrl.toString()}, false));
        return factory.newSchema(file);
    }
}

