/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.service;

import fr.gouv.vitamui.pastis.common.dto.ElementProperties;
import fr.gouv.vitamui.pastis.common.service.PuaPastisValidator;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PuaFromJSON {
    private static final String SCHEMA = "http://json-schema.org/draft-04/schema";
    private static final String TYPE = "object";
    private final PuaPastisValidator puaPastisValidator;

    @Autowired
    public PuaFromJSON(PuaPastisValidator puaPastisValidator) {
        this.puaPastisValidator = puaPastisValidator;
    }

    public String getControlSchemaFromElementProperties(ElementProperties elementProperties) throws IOException {
        JSONObject controlSchema = this.puaPastisValidator.sortedJSON();
        controlSchema.put("$schema", (Object)SCHEMA);
        controlSchema.put("type", (Object)TYPE);
        controlSchema.put("additionalProperties", elementProperties.isAdditionalProperties());
        this.addPatternPropertiesForManagement(elementProperties, controlSchema);
        List<ElementProperties> elementsForTree = this.puaPastisValidator.ignoreMetadata(elementProperties);
        List<String> rerquiredElements = this.puaPastisValidator.getHeadRequired(elementsForTree);
        if (CollectionUtils.isNotEmpty(rerquiredElements)) {
            controlSchema.put("required", this.puaPastisValidator.getHeadRequired(elementsForTree));
        }
        JSONArray allElements = this.puaPastisValidator.getJSONObjectFromAllTree(elementsForTree);
        JSONObject sortedElements = this.getJSONObjectsFromJSonArray(allElements);
        controlSchema.put("properties", (Object)sortedElements);
        return controlSchema.toString();
    }

    public String getDefinitions() {
        return this.puaPastisValidator.getDefinitionsFromExpectedProfile().toString();
    }

    private JSONObject getJSONObjectsFromJSonArray(JSONArray array) {
        JSONObject sortedJSONObject = this.puaPastisValidator.sortedJSON();
        for (JSONObject jsonObject : array) {
            for (String key : jsonObject.keySet()) {
                sortedJSONObject.put(key, jsonObject.get(key));
            }
        }
        return sortedJSONObject;
    }

    private void addPatternPropertiesForManagement(ElementProperties elementProperties, JSONObject controlSchema) {
        ElementProperties managementElementProperties = this.puaPastisValidator.getManagementElementProperties(elementProperties);
        if (Objects.isNull(managementElementProperties) || !managementElementProperties.getChildren().isEmpty()) {
            return;
        }
        controlSchema.put("patternProperties", (Object)new JSONObject().put("#management", (Object)new JSONObject().put("additionalProperties", managementElementProperties.isAdditionalProperties())));
    }
}

