/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.pastis.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitamui.pastis.common.dto.PuaData;
import fr.gouv.vitamui.pastis.common.util.RNGConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public class ElementProperties {
    private boolean additionalProperties;
    private String name;
    private String type;
    private String cardinality;
    private String groupOrChoice;
    private String valueOrData;
    private String dataType;
    private String value;
    private String documentation;
    private String editName;
    @JsonIgnore
    private Object sedaData;
    private int level;
    private Long id;
    private Long parentId;
    @JsonIgnore
    private ElementProperties parent;
    private List<ElementProperties> choices = new ArrayList<ElementProperties>();
    private List<ElementProperties> children = new ArrayList<ElementProperties>();
    private PuaData puaData;

    public void setCardinality(String cardinality) {
        this.cardinality = null != RNGConstants.getCardinalityMap().get(cardinality) ? RNGConstants.getCardinalityMap().get(cardinality) : cardinality;
    }

    public String getGroupOrChoice() {
        return this.groupOrChoice;
    }

    public void setGroupOrChoice(String groupOrChoice) {
        this.groupOrChoice = RNGConstants.getGroupOrChoiceMap().getOrDefault(groupOrChoice, groupOrChoice);
    }

    public void initTree(ElementProperties json) {
        for (ElementProperties child : json.getChildren()) {
            child.setParent(json);
            this.initTree(child);
        }
    }

    public Stream<ElementProperties> flattened() {
        return Stream.concat(Stream.of(this), this.children.stream().flatMap(ElementProperties::flattened));
    }

    @Generated
    public boolean isAdditionalProperties() {
        return this.additionalProperties;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getCardinality() {
        return this.cardinality;
    }

    @Generated
    public String getValueOrData() {
        return this.valueOrData;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getDocumentation() {
        return this.documentation;
    }

    @Generated
    public String getEditName() {
        return this.editName;
    }

    @Generated
    public Object getSedaData() {
        return this.sedaData;
    }

    @Generated
    public int getLevel() {
        return this.level;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getParentId() {
        return this.parentId;
    }

    @Generated
    public ElementProperties getParent() {
        return this.parent;
    }

    @Generated
    public List<ElementProperties> getChoices() {
        return this.choices;
    }

    @Generated
    public List<ElementProperties> getChildren() {
        return this.children;
    }

    @Generated
    public PuaData getPuaData() {
        return this.puaData;
    }

    @Generated
    public void setAdditionalProperties(boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setValueOrData(String valueOrData) {
        this.valueOrData = valueOrData;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @Generated
    public void setEditName(String editName) {
        this.editName = editName;
    }

    @JsonIgnore
    @Generated
    public void setSedaData(Object sedaData) {
        this.sedaData = sedaData;
    }

    @Generated
    public void setLevel(int level) {
        this.level = level;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @JsonIgnore
    @Generated
    public void setParent(ElementProperties parent) {
        this.parent = parent;
    }

    @Generated
    public void setChoices(List<ElementProperties> choices) {
        this.choices = choices;
    }

    @Generated
    public void setChildren(List<ElementProperties> children) {
        this.children = children;
    }

    @Generated
    public void setPuaData(PuaData puaData) {
        this.puaData = puaData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementProperties)) {
            return false;
        }
        ElementProperties other = (ElementProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAdditionalProperties() != other.isAdditionalProperties()) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$parentId = this.getParentId();
        Long other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$cardinality = this.getCardinality();
        String other$cardinality = other.getCardinality();
        if (this$cardinality == null ? other$cardinality != null : !this$cardinality.equals(other$cardinality)) {
            return false;
        }
        String this$groupOrChoice = this.getGroupOrChoice();
        String other$groupOrChoice = other.getGroupOrChoice();
        if (this$groupOrChoice == null ? other$groupOrChoice != null : !this$groupOrChoice.equals(other$groupOrChoice)) {
            return false;
        }
        String this$valueOrData = this.getValueOrData();
        String other$valueOrData = other.getValueOrData();
        if (this$valueOrData == null ? other$valueOrData != null : !this$valueOrData.equals(other$valueOrData)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$documentation = this.getDocumentation();
        String other$documentation = other.getDocumentation();
        if (this$documentation == null ? other$documentation != null : !this$documentation.equals(other$documentation)) {
            return false;
        }
        String this$editName = this.getEditName();
        String other$editName = other.getEditName();
        if (this$editName == null ? other$editName != null : !this$editName.equals(other$editName)) {
            return false;
        }
        Object this$sedaData = this.getSedaData();
        Object other$sedaData = other.getSedaData();
        if (this$sedaData == null ? other$sedaData != null : !this$sedaData.equals(other$sedaData)) {
            return false;
        }
        ElementProperties this$parent = this.getParent();
        ElementProperties other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<ElementProperties> this$choices = this.getChoices();
        List<ElementProperties> other$choices = other.getChoices();
        if (this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices)) {
            return false;
        }
        List<ElementProperties> this$children = this.getChildren();
        List<ElementProperties> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        PuaData this$puaData = this.getPuaData();
        PuaData other$puaData = other.getPuaData();
        return !(this$puaData == null ? other$puaData != null : !((Object)this$puaData).equals(other$puaData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElementProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAdditionalProperties() ? 79 : 97);
        result = result * 59 + this.getLevel();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $cardinality = this.getCardinality();
        result = result * 59 + ($cardinality == null ? 43 : $cardinality.hashCode());
        String $groupOrChoice = this.getGroupOrChoice();
        result = result * 59 + ($groupOrChoice == null ? 43 : $groupOrChoice.hashCode());
        String $valueOrData = this.getValueOrData();
        result = result * 59 + ($valueOrData == null ? 43 : $valueOrData.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $documentation = this.getDocumentation();
        result = result * 59 + ($documentation == null ? 43 : $documentation.hashCode());
        String $editName = this.getEditName();
        result = result * 59 + ($editName == null ? 43 : $editName.hashCode());
        Object $sedaData = this.getSedaData();
        result = result * 59 + ($sedaData == null ? 43 : $sedaData.hashCode());
        ElementProperties $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<ElementProperties> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        List<ElementProperties> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        PuaData $puaData = this.getPuaData();
        result = result * 59 + ($puaData == null ? 43 : ((Object)$puaData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ElementProperties(additionalProperties=" + this.isAdditionalProperties() + ", name=" + this.getName() + ", type=" + this.getType() + ", cardinality=" + this.getCardinality() + ", groupOrChoice=" + this.getGroupOrChoice() + ", valueOrData=" + this.getValueOrData() + ", dataType=" + this.getDataType() + ", value=" + this.getValue() + ", documentation=" + this.getDocumentation() + ", editName=" + this.getEditName() + ", sedaData=" + this.getSedaData() + ", level=" + this.getLevel() + ", id=" + this.getId() + ", parentId=" + this.getParentId() + ", parent=" + this.getParent() + ", choices=" + this.getChoices() + ", children=" + this.getChildren() + ", puaData=" + this.getPuaData() + ")";
    }

    @Generated
    public ElementProperties() {
    }
}

